/*
 * Decompiled with CFR 0.152.
 */
package engineer.echo.easyapi.compiler;

import engineer.echo.easyapi.annotation.JobApi;
import engineer.echo.easyapi.annotation.JobServer;
import engineer.echo.easyapi.compiler.CompilerHelper;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class EasyProcessor
extends AbstractProcessor {
    private Filer filer;
    private Messager messager;
    private String appId = "engineer.echo.easyapi";
    private Set<String> supportAnnos = new LinkedHashSet<String>();
    private HashMap<String, String> metaInfo = new HashMap();

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.filer = env.getFiler();
        this.messager = env.getMessager();
        this.supportAnnos.add(JobServer.class.getCanonicalName());
        this.supportAnnos.add(JobApi.class.getCanonicalName());
        Map<String, String> options = env.getOptions();
        if (options.containsKey("easyapi.appId")) {
            this.appId = options.get("easyapi.appId");
            if (this.appId == null || this.appId.length() == 0) {
                this.appId = "engineer.echo.easyapi";
            }
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment env) {
        this.metaInfo.clear();
        for (Element element : env.getElementsAnnotatedWith(JobServer.class)) {
            if (element.getKind() != ElementKind.CLASS || !(element instanceof TypeElement)) continue;
            JobServer jobServer = element.getAnnotation(JobServer.class);
            String className = ((TypeElement)element).getQualifiedName().toString();
            if (!this.metaInfo.containsKey(jobServer.uniqueId())) {
                if (CompilerHelper.createMetaInfoFile(this.filer, this.appId, jobServer.uniqueId(), className)) {
                    this.metaInfo.put(jobServer.uniqueId(), className);
                    continue;
                }
                String message = className + " generate failed for  uniqueId  " + jobServer.uniqueId();
                this.messager.printMessage(Diagnostic.Kind.ERROR, message);
                throw new IllegalArgumentException(message);
            }
            String message = jobServer.uniqueId() + " has bind to " + this.metaInfo.get(jobServer.uniqueId()) + " please set an uniqueId to " + className;
            this.messager.printMessage(Diagnostic.Kind.ERROR, message);
            throw new IllegalArgumentException(message);
        }
        for (Element element : env.getElementsAnnotatedWith(JobApi.class)) {
            String error;
            JobApi jobApi;
            if (element.getKind() != ElementKind.INTERFACE || !(element instanceof TypeElement) || !(jobApi = element.getAnnotation(JobApi.class)).retrofit() || (error = CompilerHelper.createRetrofitApi(this.filer, (TypeElement)element)) == null) continue;
            this.messager.printMessage(Diagnostic.Kind.ERROR, error);
            throw new IllegalArgumentException(error);
        }
        return true;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.supportAnnos;
    }
}

