/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.persistence.hibernate.module;

import com.google.inject.Inject;
import dev.voidframework.core.utils.ProxyDetectorUtils;
import dev.voidframework.persistence.AbstractTransactionalInterceptor;
import dev.voidframework.persistence.hibernate.module.EntityManagerProvider;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.TransactionRequiredException;
import jakarta.transaction.Transactional;
import org.aopalliance.intercept.MethodInvocation;

public class TransactionalInterceptor
extends AbstractTransactionalInterceptor {
    private EntityManagerProvider entityManagerProvider;

    @Inject
    public void setDataSourceManagerProvider(EntityManagerProvider entityManagerProvider) {
        this.entityManagerProvider = entityManagerProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        boolean isInitiator = false;
        Transactional transactionalAnnotation = methodInvocation.getMethod().getAnnotation(Transactional.class);
        if (transactionalAnnotation == null) {
            transactionalAnnotation = methodInvocation.getThis().getClass().getAnnotation(Transactional.class);
        }
        if (this.entityManagerProvider.isEntityManagerMustBeInitialized()) {
            this.entityManagerProvider.initializeNewEntityFactoryManager();
            isInitiator = true;
        }
        EntityManager entityManager = this.entityManagerProvider.get();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            Object object = switch (transactionalAnnotation.value()) {
                default -> throw new IncompatibleClassChangeError();
                case Transactional.TxType.MANDATORY -> {
                    if (!transaction.isActive()) {
                        throw new TransactionRequiredException("%s::%s called outside a transaction context".formatted(ProxyDetectorUtils.isProxy((Object)methodInvocation.getThis()) ? methodInvocation.getThis().getClass().getSuperclass().getName() : methodInvocation.getThis().getClass().getName(), methodInvocation.getMethod().getName()));
                    }
                    yield methodInvocation.proceed();
                }
                case Transactional.TxType.NEVER -> {
                    if (transaction.isActive()) {
                        throw new InvalidTransactionException("%s::%s called inside a transaction context".formatted(ProxyDetectorUtils.isProxy((Object)methodInvocation.getThis()) ? methodInvocation.getThis().getClass().getSuperclass().getName() : methodInvocation.getThis().getClass().getName(), methodInvocation.getMethod().getName()));
                    }
                    yield methodInvocation.proceed();
                }
                case Transactional.TxType.NOT_SUPPORTED -> {
                    if (transaction.isActive()) {
                        isInitiator = true;
                        this.entityManagerProvider.initializeNewEntityFactoryManager();
                    }
                    yield methodInvocation.proceed();
                }
                case Transactional.TxType.REQUIRED -> {
                    if (!transaction.isActive()) {
                        yield this.proceedInTransaction(methodInvocation, transaction, transactionalAnnotation);
                    }
                    yield methodInvocation.proceed();
                }
                case Transactional.TxType.REQUIRES_NEW -> {
                    if (!isInitiator) {
                        isInitiator = true;
                        this.entityManagerProvider.initializeNewEntityFactoryManager();
                        EntityTransaction newEntityTransaction = this.entityManagerProvider.get().getTransaction();
                        yield this.proceedInTransaction(methodInvocation, newEntityTransaction, transactionalAnnotation);
                    }
                    yield this.proceedInTransaction(methodInvocation, transaction, transactionalAnnotation);
                }
                case Transactional.TxType.SUPPORTS -> methodInvocation.proceed();
            };
            return object;
        }
        finally {
            if (isInitiator) {
                this.entityManagerProvider.destroyLatestEntityManager();
            }
        }
    }

    private Object proceedInTransaction(MethodInvocation methodInvocation, EntityTransaction transaction, Transactional transactionalAnnotation) throws Throwable {
        try {
            transaction.begin();
            Object result = methodInvocation.proceed();
            transaction.commit();
            return result;
        }
        catch (Throwable throwable) {
            if (this.hasToRollback(transactionalAnnotation, throwable.getClass())) {
                transaction.rollback();
            } else {
                transaction.commit();
            }
            throw throwable;
        }
    }
}

