/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.persistence.hibernate.module;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import dev.voidframework.core.bindable.Bindable;
import dev.voidframework.core.lifecycle.LifeCycleStart;
import dev.voidframework.core.utils.ConfigurationUtils;
import dev.voidframework.datasource.exception.DataSourceException;
import jakarta.persistence.EntityManager;
import java.lang.annotation.Annotation;
import java.util.Set;

@Bindable
public final class PersistenceLifeCycle {
    private final Config configuration;
    private final Injector injector;

    @Inject
    public PersistenceLifeCycle(Config configuration, Injector injector) {
        this.configuration = configuration;
        this.injector = injector;
    }

    @LifeCycleStart(priority=51)
    public void forceEntityManagerFactoryInitialisation() {
        Set dataSourceNameSet = ConfigurationUtils.getAllRootLevelPaths((Config)this.configuration, (String)"voidframework.datasource");
        if (dataSourceNameSet.isEmpty()) {
            throw new DataSourceException.NotConfigured();
        }
        for (String dataSourceName : dataSourceNameSet) {
            Key key = Key.get(EntityManager.class, (Annotation)Names.named((String)dataSourceName));
            Provider entityManagerProvider = this.injector.getProvider(key);
            EntityManager entityManager = (EntityManager)entityManagerProvider.get();
            if (entityManager == null) continue;
            entityManager.close();
        }
    }
}

