/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.persistence.hibernate.module;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import dev.voidframework.core.utils.ConfigurationUtils;
import dev.voidframework.datasource.exception.DataSourceException;
import dev.voidframework.persistence.hibernate.module.EntityManagerProvider;
import dev.voidframework.persistence.hibernate.module.TransactionalInterceptor;
import jakarta.persistence.EntityManager;
import jakarta.transaction.Transactional;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;

public final class HibernateModule
extends AbstractModule {
    private final Config configuration;

    public HibernateModule(Config configuration) {
        this.configuration = configuration;
    }

    protected void configure() {
        Set dataSourceNameSet = ConfigurationUtils.getAllRootLevelPaths((Config)this.configuration, (String)"voidframework.datasource");
        if (dataSourceNameSet.isEmpty()) {
            throw new DataSourceException.NotConfigured();
        }
        String modelsJarUrlPattern = this.configuration.getString("voidframework.persistence.modelsJarUrlPattern");
        if (modelsJarUrlPattern != null && modelsJarUrlPattern.equalsIgnoreCase("auto")) {
            modelsJarUrlPattern = "(.*)";
        }
        for (String dataSourceName : dataSourceNameSet) {
            EntityManagerProvider entityManagerProvider = new EntityManagerProvider(dataSourceName, modelsJarUrlPattern);
            this.requestInjection(entityManagerProvider);
            this.bind(EntityManager.class).annotatedWith((Annotation)Names.named((String)dataSourceName)).toProvider((Provider)entityManagerProvider);
            if (!dataSourceName.equals("default")) continue;
            this.bind(EntityManager.class).toProvider((Provider)entityManagerProvider);
            this.bind(EntityManagerProvider.class).toInstance((Object)entityManagerProvider);
        }
        TransactionalInterceptor methodInterceptor = new TransactionalInterceptor();
        this.requestInjection((Object)methodInterceptor);
        this.bindInterceptor(Matchers.annotatedWith(Transactional.class), Matchers.any(), new MethodInterceptor[]{methodInterceptor});
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Transactional.class), new MethodInterceptor[]{methodInterceptor});
    }
}

