/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.persistence.hibernate.module;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import dev.voidframework.datasource.DataSourceManager;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.ClassTransformer;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EntityManagerProvider
implements Provider<EntityManager> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityManagerProvider.class);
    private final String dataSourceName;
    private final String modelsJarUrlPattern;
    private final ThreadLocal<Deque<EntityManager>> currentEntityManager;
    private Provider<DataSourceManager> dataSourceManagerProvider;
    private EntityManagerFactory entityManagerFactory;

    public EntityManagerProvider(String dataSourceName, String modelsJarUrlPattern) {
        this.dataSourceName = dataSourceName;
        this.modelsJarUrlPattern = modelsJarUrlPattern;
        this.currentEntityManager = new ThreadLocal();
    }

    @Inject
    public void setDataSourceManagerProvider(Provider<DataSourceManager> dataSourceManagerProvider) {
        this.dataSourceManagerProvider = dataSourceManagerProvider;
    }

    public EntityManager get() {
        if (this.isEntityManagerMustBeInitialized()) {
            this.createEntityManagerFactoryIfNeeded();
            return this.entityManagerFactory.createEntityManager();
        }
        return this.currentEntityManager.get().getFirst();
    }

    public void initializeNewEntityFactoryManager() {
        this.createEntityManagerFactoryIfNeeded();
        Deque<EntityManager> currentEntityManagerDeque = this.currentEntityManager.get();
        if (currentEntityManagerDeque == null) {
            currentEntityManagerDeque = new ArrayDeque<EntityManager>();
            this.currentEntityManager.set(currentEntityManagerDeque);
        }
        currentEntityManagerDeque.addFirst(this.entityManagerFactory.createEntityManager());
    }

    public void destroyLatestEntityManager() {
        Deque<EntityManager> currentEntityManagerDeque = this.currentEntityManager.get();
        if (currentEntityManagerDeque == null) {
            return;
        }
        EntityManager entityManager = currentEntityManagerDeque.removeFirst();
        if (entityManager != null) {
            entityManager.close();
        }
        if (currentEntityManagerDeque.isEmpty()) {
            this.currentEntityManager.remove();
        }
    }

    public boolean isEntityManagerMustBeInitialized() {
        Deque<EntityManager> currentEntityManagerDeque = this.currentEntityManager.get();
        return currentEntityManagerDeque == null || currentEntityManagerDeque.isEmpty();
    }

    private void createEntityManagerFactoryIfNeeded() {
        if (this.entityManagerFactory == null) {
            List<URL> javaFileUrlList = this.createModelsJarFileUrls();
            this.entityManagerFactory = new HibernatePersistenceProvider().createContainerEntityManagerFactory((PersistenceUnitInfo)new PersistenceUnitInfoIml(this.dataSourceName, javaFileUrlList), Map.of("hibernate.connection.datasource", ((DataSourceManager)this.dataSourceManagerProvider.get()).getDataSource(this.dataSourceName), "hibernate.hbm2ddl.auto", "none"));
        }
    }

    private List<URL> createModelsJarFileUrls() {
        try {
            URL url;
            int idx;
            String urlAsString;
            ArrayList<String> javaFilePathList = new ArrayList<String>();
            if (this.modelsJarUrlPattern != null) {
                ArrayList<URL> urlList = Collections.list(this.getClass().getClassLoader().getResources(""));
                urlList.addAll(Collections.list(this.getClass().getClassLoader().getResources("META-INF")));
                for (URL url2 : urlList) {
                    urlAsString = url2.toString();
                    idx = urlAsString.indexOf("/META-INF") + 1;
                    if (idx > 0) {
                        urlAsString = urlAsString.substring(0, idx);
                    }
                    if (!urlAsString.matches(this.modelsJarUrlPattern)) continue;
                    javaFilePathList.add(urlAsString);
                }
            }
            if ((url = this.getClass().getResource("/application.conf")) != null) {
                urlAsString = url.toString();
                idx = urlAsString.indexOf("/application.conf") + 1;
                if (idx > 0) {
                    urlAsString = urlAsString.substring(0, idx);
                }
                javaFilePathList.add(0, urlAsString);
            }
            return javaFilePathList.stream().distinct().map(this::createURL).filter(Objects::nonNull).toList();
        }
        catch (IOException ex) {
            LOGGER.error("Can't create list of models Jar file URLs", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    private URL createURL(String urlAsString) {
        try {
            return new URL(urlAsString);
        }
        catch (MalformedURLException ex) {
            LOGGER.error("Can't create URL", (Throwable)ex);
            return null;
        }
    }

    private static class PersistenceUnitInfoIml
    implements PersistenceUnitInfo {
        private final String persistenceUnitName;
        private final List<URL> jarUrlList;

        private PersistenceUnitInfoIml(String persistenceUnitName, List<URL> jarUrlList) {
            this.persistenceUnitName = persistenceUnitName;
            this.jarUrlList = jarUrlList;
        }

        public String getPersistenceUnitName() {
            return this.persistenceUnitName;
        }

        public String getPersistenceProviderClassName() {
            return null;
        }

        public PersistenceUnitTransactionType getTransactionType() {
            return PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }

        public DataSource getJtaDataSource() {
            return null;
        }

        public DataSource getNonJtaDataSource() {
            return null;
        }

        public List<String> getMappingFileNames() {
            return Collections.emptyList();
        }

        public List<URL> getJarFileUrls() {
            return this.jarUrlList;
        }

        public URL getPersistenceUnitRootUrl() {
            return null;
        }

        public List<String> getManagedClassNames() {
            return Collections.emptyList();
        }

        public boolean excludeUnlistedClasses() {
            return false;
        }

        public SharedCacheMode getSharedCacheMode() {
            return null;
        }

        public ValidationMode getValidationMode() {
            return null;
        }

        public Properties getProperties() {
            return new Properties();
        }

        public String getPersistenceXMLSchemaVersion() {
            return null;
        }

        public ClassLoader getClassLoader() {
            return null;
        }

        public void addTransformer(ClassTransformer classTransformer) {
        }

        public ClassLoader getNewTempClassLoader() {
            return null;
        }
    }
}

