/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.persistence.hibernate.cuid;

import dev.voidframework.core.lang.CUID;
import dev.voidframework.persistence.hibernate.annotation.CuidGenerator;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.spi.CustomIdGeneratorCreationContext;

public final class CUIDIdentifierGenerator
implements IdentifierGenerator {
    private final transient Supplier<Object> cuidSupplier;

    public CUIDIdentifierGenerator(CuidGenerator config, Member annotatedMember, CustomIdGeneratorCreationContext context) {
        Class<?> memberClassType = annotatedMember instanceof Method ? ((Method)annotatedMember).getReturnType() : ((Field)annotatedMember).getType();
        if (CUID.class.isAssignableFrom(memberClassType)) {
            this.cuidSupplier = CUIDIdentifierGenerator::generateAsCUID;
        } else if (String.class.isAssignableFrom(memberClassType)) {
            this.cuidSupplier = CUIDIdentifierGenerator::generateAsString;
        } else if (byte[].class.isAssignableFrom(memberClassType)) {
            this.cuidSupplier = CUIDIdentifierGenerator::generateAsByteArray;
        } else {
            throw new HibernateException("Unanticipated return type '" + memberClassType.getName() + "' for CUID conversion");
        }
    }

    private static CUID generateAsCUID() {
        return CUID.randomCUID();
    }

    private static String generateAsString() {
        return CUID.randomCUID().toString();
    }

    private static byte[] generateAsByteArray() {
        return CUID.randomCUID().toString().getBytes(StandardCharsets.UTF_8);
    }

    public Object generate(SharedSessionContractImplementor sharedSessionContractImplementor, Object o) throws HibernateException {
        return this.cuidSupplier.get();
    }
}

