/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.sample.websocket;

import java.util.Collections;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@SpringBootApplication
public class WebSocketSampleApplication {
    public static void main(String[] args) {
        SpringApplication.run(WebSocketSampleApplication.class, (String[])args);
    }

    @Bean
    public HandlerMapping handlerMapping() {
        Map<String, WebSocketHandler> handlers = Collections.singletonMap("/echo-upper", arg_0 -> this.toUppercaseHandler(arg_0));
        SimpleUrlHandlerMapping handlerMapping = new SimpleUrlHandlerMapping();
        handlerMapping.setUrlMap(handlers);
        handlerMapping.setOrder(-1);
        return handlerMapping;
    }

    private Mono<Void> toUppercaseHandler(WebSocketSession session) {
        Flux messages = session.receive().filter(message -> message.getType() == WebSocketMessage.Type.TEXT).map(message -> message.getPayloadAsText().toUpperCase()).map(arg_0 -> ((WebSocketSession)session).textMessage(arg_0));
        return session.send((Publisher)messages);
    }
}

