/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.tuf.model.Delegations;
import dev.sigstore.tuf.model.TargetMeta;
import dev.sigstore.tuf.model.TufMeta;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TargetMeta", generator="Immutables")
@Immutable
public final class ImmutableTargetMeta
implements TargetMeta {
    private final String type;
    private final String expires;
    private final String specVersion;
    private final int version;
    @Nullable
    private final Delegations delegations;
    private final ImmutableMap<String, TargetMeta.TargetData> targets;

    private ImmutableTargetMeta(String type, String expires, String specVersion, int version, @Nullable Delegations delegations, ImmutableMap<String, TargetMeta.TargetData> targets) {
        this.type = type;
        this.expires = expires;
        this.specVersion = specVersion;
        this.version = version;
        this.delegations = delegations;
        this.targets = targets;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getExpires() {
        return this.expires;
    }

    @Override
    public String getSpecVersion() {
        return this.specVersion;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public Optional<Delegations> getDelegations() {
        return Optional.ofNullable(this.delegations);
    }

    public ImmutableMap<String, TargetMeta.TargetData> getTargets() {
        return this.targets;
    }

    public final ImmutableTargetMeta withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableTargetMeta(newValue, this.expires, this.specVersion, this.version, this.delegations, this.targets);
    }

    public final ImmutableTargetMeta withExpires(String value) {
        String newValue = Objects.requireNonNull(value, "expires");
        if (this.expires.equals(newValue)) {
            return this;
        }
        return new ImmutableTargetMeta(this.type, newValue, this.specVersion, this.version, this.delegations, this.targets);
    }

    public final ImmutableTargetMeta withSpecVersion(String value) {
        String newValue = Objects.requireNonNull(value, "specVersion");
        if (this.specVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableTargetMeta(this.type, this.expires, newValue, this.version, this.delegations, this.targets);
    }

    public final ImmutableTargetMeta withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableTargetMeta(this.type, this.expires, this.specVersion, value, this.delegations, this.targets);
    }

    public final ImmutableTargetMeta withDelegations(Delegations value) {
        Delegations newValue = Objects.requireNonNull(value, "delegations");
        if (this.delegations == newValue) {
            return this;
        }
        return new ImmutableTargetMeta(this.type, this.expires, this.specVersion, this.version, newValue, this.targets);
    }

    public final ImmutableTargetMeta withDelegations(Optional<? extends Delegations> optional) {
        Delegations value = optional.orElse(null);
        if (this.delegations == value) {
            return this;
        }
        return new ImmutableTargetMeta(this.type, this.expires, this.specVersion, this.version, value, this.targets);
    }

    public final ImmutableTargetMeta withTargets(Map<String, ? extends TargetMeta.TargetData> entries) {
        if (this.targets == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableTargetMeta(this.type, this.expires, this.specVersion, this.version, this.delegations, (ImmutableMap<String, TargetMeta.TargetData>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTargetMeta && this.equalTo(0, (ImmutableTargetMeta)another);
    }

    private boolean equalTo(int synthetic, ImmutableTargetMeta another) {
        return this.type.equals(another.type) && this.expires.equals(another.expires) && this.specVersion.equals(another.specVersion) && this.version == another.version && Objects.equals(this.delegations, another.delegations) && this.targets.equals(another.targets);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.expires.hashCode();
        h += (h << 5) + this.specVersion.hashCode();
        h += (h << 5) + this.version;
        h += (h << 5) + Objects.hashCode(this.delegations);
        h += (h << 5) + this.targets.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TargetMeta").omitNullValues().add("type", (Object)this.type).add("expires", (Object)this.expires).add("specVersion", (Object)this.specVersion).add("version", this.version).add("delegations", (Object)this.delegations).add("targets", this.targets).toString();
    }

    public static ImmutableTargetMeta copyOf(TargetMeta instance) {
        if (instance instanceof ImmutableTargetMeta) {
            return (ImmutableTargetMeta)instance;
        }
        return ImmutableTargetMeta.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TargetMeta", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_EXPIRES = 2L;
        private static final long INIT_BIT_SPEC_VERSION = 4L;
        private static final long INIT_BIT_VERSION = 8L;
        private long initBits = 15L;
        @Nullable
        private String type;
        @Nullable
        private String expires;
        @Nullable
        private String specVersion;
        private int version;
        @Nullable
        private Delegations delegations;
        private ImmutableMap.Builder<String, TargetMeta.TargetData> targets = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TargetMeta instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TufMeta instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TufMeta instance;
            long bits = 0L;
            if (object instanceof TargetMeta) {
                Optional<Delegations> delegationsOptional;
                instance = (TargetMeta)object;
                if ((bits & 1L) == 0L) {
                    this.expires(instance.getExpires());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.specVersion(instance.getSpecVersion());
                    bits |= 2L;
                }
                if ((delegationsOptional = instance.getDelegations()).isPresent()) {
                    this.delegations(delegationsOptional);
                }
                if ((bits & 4L) == 0L) {
                    this.type(instance.getType());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.version(instance.getVersion());
                    bits |= 8L;
                }
                this.putAllTargets(instance.getTargets());
            }
            if (object instanceof TufMeta) {
                instance = (TufMeta)object;
                if ((bits & 1L) == 0L) {
                    this.expires(instance.getExpires());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.specVersion(instance.getSpecVersion());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.type(instance.getType());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.version(instance.getVersion());
                    bits |= 8L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expires(String expires) {
            this.expires = Objects.requireNonNull(expires, "expires");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder specVersion(String specVersion) {
            this.specVersion = Objects.requireNonNull(specVersion, "specVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(int version) {
            this.version = version;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder delegations(Delegations delegations) {
            this.delegations = Objects.requireNonNull(delegations, "delegations");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder delegations(Optional<? extends Delegations> delegations) {
            this.delegations = delegations.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putTargets(String key, TargetMeta.TargetData value) {
            this.targets.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putTargets(Map.Entry<String, ? extends TargetMeta.TargetData> entry) {
            this.targets.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targets(Map<String, ? extends TargetMeta.TargetData> entries) {
            this.targets = ImmutableMap.builder();
            return this.putAllTargets(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllTargets(Map<String, ? extends TargetMeta.TargetData> entries) {
            this.targets.putAll(entries);
            return this;
        }

        public ImmutableTargetMeta build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTargetMeta(this.type, this.expires, this.specVersion, this.version, this.delegations, (ImmutableMap<String, TargetMeta.TargetData>)this.targets.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("expires");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("specVersion");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build TargetMeta, some of required attributes are not set " + attributes;
        }
    }
}

