/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.model;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.tuf.model.Hashes;
import dev.sigstore.tuf.model.SnapshotMeta;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SnapshotMeta.SnapshotTarget", generator="Immutables")
@Immutable
public final class ImmutableSnapshotTarget
implements SnapshotMeta.SnapshotTarget {
    private final Hashes hashes;
    private final int length;
    private final int version;

    private ImmutableSnapshotTarget(Hashes hashes, int length, int version) {
        this.hashes = hashes;
        this.length = length;
        this.version = version;
    }

    @Override
    public Hashes getHashes() {
        return this.hashes;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public final ImmutableSnapshotTarget withHashes(Hashes value) {
        if (this.hashes == value) {
            return this;
        }
        Hashes newValue = Objects.requireNonNull(value, "hashes");
        return new ImmutableSnapshotTarget(newValue, this.length, this.version);
    }

    public final ImmutableSnapshotTarget withLength(int value) {
        if (this.length == value) {
            return this;
        }
        return new ImmutableSnapshotTarget(this.hashes, value, this.version);
    }

    public final ImmutableSnapshotTarget withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableSnapshotTarget(this.hashes, this.length, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSnapshotTarget && this.equalTo(0, (ImmutableSnapshotTarget)another);
    }

    private boolean equalTo(int synthetic, ImmutableSnapshotTarget another) {
        return this.hashes.equals(another.hashes) && this.length == another.length && this.version == another.version;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.hashes.hashCode();
        h += (h << 5) + this.length;
        h += (h << 5) + this.version;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SnapshotTarget").omitNullValues().add("hashes", (Object)this.hashes).add("length", this.length).add("version", this.version).toString();
    }

    public static ImmutableSnapshotTarget copyOf(SnapshotMeta.SnapshotTarget instance) {
        if (instance instanceof ImmutableSnapshotTarget) {
            return (ImmutableSnapshotTarget)instance;
        }
        return ImmutableSnapshotTarget.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SnapshotMeta.SnapshotTarget", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HASHES = 1L;
        private static final long INIT_BIT_LENGTH = 2L;
        private static final long INIT_BIT_VERSION = 4L;
        private long initBits = 7L;
        @Nullable
        private Hashes hashes;
        private int length;
        private int version;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SnapshotMeta.SnapshotTarget instance) {
            Objects.requireNonNull(instance, "instance");
            this.hashes(instance.getHashes());
            this.length(instance.getLength());
            this.version(instance.getVersion());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hashes(Hashes hashes) {
            this.hashes = Objects.requireNonNull(hashes, "hashes");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder length(int length) {
            this.length = length;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(int version) {
            this.version = version;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSnapshotTarget build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSnapshotTarget(this.hashes, this.length, this.version);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hashes");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("length");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build SnapshotTarget, some of required attributes are not set " + attributes;
        }
    }
}

