/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.tuf.model.Role;
import dev.sigstore.tuf.model.RootRole;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RootRole", generator="Immutables")
@Immutable
public final class ImmutableRootRole
implements RootRole {
    private final ImmutableList<String> keyids;
    private final int threshold;

    private ImmutableRootRole(ImmutableList<String> keyids, int threshold) {
        this.keyids = keyids;
        this.threshold = threshold;
    }

    public ImmutableList<String> getKeyids() {
        return this.keyids;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    public final ImmutableRootRole withKeyids(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRootRole((ImmutableList<String>)newValue, this.threshold);
    }

    public final ImmutableRootRole withKeyids(Iterable<String> elements) {
        if (this.keyids == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRootRole((ImmutableList<String>)newValue, this.threshold);
    }

    public final ImmutableRootRole withThreshold(int value) {
        if (this.threshold == value) {
            return this;
        }
        return new ImmutableRootRole(this.keyids, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRootRole && this.equalTo(0, (ImmutableRootRole)another);
    }

    private boolean equalTo(int synthetic, ImmutableRootRole another) {
        return this.keyids.equals(another.keyids) && this.threshold == another.threshold;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.keyids.hashCode();
        h += (h << 5) + this.threshold;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RootRole").omitNullValues().add("keyids", this.keyids).add("threshold", this.threshold).toString();
    }

    public static ImmutableRootRole copyOf(RootRole instance) {
        if (instance instanceof ImmutableRootRole) {
            return (ImmutableRootRole)instance;
        }
        return ImmutableRootRole.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RootRole", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_THRESHOLD = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<String> keyids = ImmutableList.builder();
        private int threshold;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RootRole instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Role instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Role instance;
            long bits = 0L;
            if (object instanceof RootRole) {
                instance = (RootRole)object;
                if ((bits & 2L) == 0L) {
                    this.threshold(instance.getThreshold());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.addAllKeyids(instance.getKeyids());
                    bits |= 1L;
                }
            }
            if (object instanceof Role) {
                instance = (Role)object;
                if ((bits & 2L) == 0L) {
                    this.threshold(instance.getThreshold());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.addAllKeyids(instance.getKeyids());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder addKeyids(String element) {
            this.keyids.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeyids(String ... elements) {
            this.keyids.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyids(Iterable<String> elements) {
            this.keyids = ImmutableList.builder();
            return this.addAllKeyids(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllKeyids(Iterable<String> elements) {
            this.keyids.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder threshold(int threshold) {
            this.threshold = threshold;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableRootRole build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRootRole((ImmutableList<String>)this.keyids.build(), this.threshold);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("threshold");
            }
            return "Cannot build RootRole, some of required attributes are not set " + attributes;
        }
    }
}

