/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.tuf.model.Key;
import dev.sigstore.tuf.model.RootMeta;
import dev.sigstore.tuf.model.RootRole;
import dev.sigstore.tuf.model.TufMeta;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RootMeta", generator="Immutables")
@Immutable
public final class ImmutableRootMeta
implements RootMeta {
    private final String type;
    private final String expires;
    private final String specVersion;
    private final int version;
    private final boolean consistentSnapshot;
    private final ImmutableMap<String, Key> keys;
    private final ImmutableMap<String, RootRole> roles;

    private ImmutableRootMeta(String type, String expires, String specVersion, int version, boolean consistentSnapshot, ImmutableMap<String, Key> keys, ImmutableMap<String, RootRole> roles) {
        this.type = type;
        this.expires = expires;
        this.specVersion = specVersion;
        this.version = version;
        this.consistentSnapshot = consistentSnapshot;
        this.keys = keys;
        this.roles = roles;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getExpires() {
        return this.expires;
    }

    @Override
    public String getSpecVersion() {
        return this.specVersion;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean getConsistentSnapshot() {
        return this.consistentSnapshot;
    }

    public ImmutableMap<String, Key> getKeys() {
        return this.keys;
    }

    public ImmutableMap<String, RootRole> getRoles() {
        return this.roles;
    }

    public final ImmutableRootMeta withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableRootMeta(newValue, this.expires, this.specVersion, this.version, this.consistentSnapshot, this.keys, this.roles);
    }

    public final ImmutableRootMeta withExpires(String value) {
        String newValue = Objects.requireNonNull(value, "expires");
        if (this.expires.equals(newValue)) {
            return this;
        }
        return new ImmutableRootMeta(this.type, newValue, this.specVersion, this.version, this.consistentSnapshot, this.keys, this.roles);
    }

    public final ImmutableRootMeta withSpecVersion(String value) {
        String newValue = Objects.requireNonNull(value, "specVersion");
        if (this.specVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableRootMeta(this.type, this.expires, newValue, this.version, this.consistentSnapshot, this.keys, this.roles);
    }

    public final ImmutableRootMeta withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableRootMeta(this.type, this.expires, this.specVersion, value, this.consistentSnapshot, this.keys, this.roles);
    }

    public final ImmutableRootMeta withConsistentSnapshot(boolean value) {
        if (this.consistentSnapshot == value) {
            return this;
        }
        return new ImmutableRootMeta(this.type, this.expires, this.specVersion, this.version, value, this.keys, this.roles);
    }

    public final ImmutableRootMeta withKeys(Map<String, ? extends Key> entries) {
        if (this.keys == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableRootMeta(this.type, this.expires, this.specVersion, this.version, this.consistentSnapshot, (ImmutableMap<String, Key>)newValue, this.roles);
    }

    public final ImmutableRootMeta withRoles(Map<String, ? extends RootRole> entries) {
        if (this.roles == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableRootMeta(this.type, this.expires, this.specVersion, this.version, this.consistentSnapshot, this.keys, (ImmutableMap<String, RootRole>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRootMeta && this.equalTo(0, (ImmutableRootMeta)another);
    }

    private boolean equalTo(int synthetic, ImmutableRootMeta another) {
        return this.type.equals(another.type) && this.expires.equals(another.expires) && this.specVersion.equals(another.specVersion) && this.version == another.version && this.consistentSnapshot == another.consistentSnapshot && this.keys.equals(another.keys) && this.roles.equals(another.roles);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.expires.hashCode();
        h += (h << 5) + this.specVersion.hashCode();
        h += (h << 5) + this.version;
        h += (h << 5) + Booleans.hashCode((boolean)this.consistentSnapshot);
        h += (h << 5) + this.keys.hashCode();
        h += (h << 5) + this.roles.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RootMeta").omitNullValues().add("type", (Object)this.type).add("expires", (Object)this.expires).add("specVersion", (Object)this.specVersion).add("version", this.version).add("consistentSnapshot", this.consistentSnapshot).add("keys", this.keys).add("roles", this.roles).toString();
    }

    public static ImmutableRootMeta copyOf(RootMeta instance) {
        if (instance instanceof ImmutableRootMeta) {
            return (ImmutableRootMeta)instance;
        }
        return ImmutableRootMeta.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RootMeta", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_EXPIRES = 2L;
        private static final long INIT_BIT_SPEC_VERSION = 4L;
        private static final long INIT_BIT_VERSION = 8L;
        private static final long INIT_BIT_CONSISTENT_SNAPSHOT = 16L;
        private long initBits = 31L;
        @Nullable
        private String type;
        @Nullable
        private String expires;
        @Nullable
        private String specVersion;
        private int version;
        private boolean consistentSnapshot;
        private ImmutableMap.Builder<String, Key> keys = ImmutableMap.builder();
        private ImmutableMap.Builder<String, RootRole> roles = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RootMeta instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TufMeta instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TufMeta instance;
            long bits = 0L;
            if (object instanceof RootMeta) {
                instance = (RootMeta)object;
                if ((bits & 1L) == 0L) {
                    this.expires(instance.getExpires());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.specVersion(instance.getSpecVersion());
                    bits |= 2L;
                }
                this.consistentSnapshot(instance.getConsistentSnapshot());
                this.putAllKeys(instance.getKeys());
                this.putAllRoles(instance.getRoles());
                if ((bits & 4L) == 0L) {
                    this.type(instance.getType());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.version(instance.getVersion());
                    bits |= 8L;
                }
            }
            if (object instanceof TufMeta) {
                instance = (TufMeta)object;
                if ((bits & 1L) == 0L) {
                    this.expires(instance.getExpires());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.specVersion(instance.getSpecVersion());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.type(instance.getType());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.version(instance.getVersion());
                    bits |= 8L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expires(String expires) {
            this.expires = Objects.requireNonNull(expires, "expires");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder specVersion(String specVersion) {
            this.specVersion = Objects.requireNonNull(specVersion, "specVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(int version) {
            this.version = version;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder consistentSnapshot(boolean consistentSnapshot) {
            this.consistentSnapshot = consistentSnapshot;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putKeys(String key, Key value) {
            this.keys.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putKeys(Map.Entry<String, ? extends Key> entry) {
            this.keys.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keys(Map<String, ? extends Key> entries) {
            this.keys = ImmutableMap.builder();
            return this.putAllKeys(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllKeys(Map<String, ? extends Key> entries) {
            this.keys.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putRoles(String key, RootRole value) {
            this.roles.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putRoles(Map.Entry<String, ? extends RootRole> entry) {
            this.roles.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder roles(Map<String, ? extends RootRole> entries) {
            this.roles = ImmutableMap.builder();
            return this.putAllRoles(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllRoles(Map<String, ? extends RootRole> entries) {
            this.roles.putAll(entries);
            return this;
        }

        public ImmutableRootMeta build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRootMeta(this.type, this.expires, this.specVersion, this.version, this.consistentSnapshot, (ImmutableMap<String, Key>)this.keys.build(), (ImmutableMap<String, RootRole>)this.roles.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("expires");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("specVersion");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("consistentSnapshot");
            }
            return "Cannot build RootMeta, some of required attributes are not set " + attributes;
        }
    }
}

