/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.tuf.model.Root;
import dev.sigstore.tuf.model.RootMeta;
import dev.sigstore.tuf.model.Signature;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Root", generator="Immutables")
@Immutable
public final class ImmutableRoot
implements Root {
    private final ImmutableList<Signature> signatures;
    private final RootMeta signedMeta;

    private ImmutableRoot(ImmutableList<Signature> signatures, RootMeta signedMeta) {
        this.signatures = signatures;
        this.signedMeta = signedMeta;
    }

    public ImmutableList<Signature> getSignatures() {
        return this.signatures;
    }

    @Override
    public RootMeta getSignedMeta() {
        return this.signedMeta;
    }

    public final ImmutableRoot withSignatures(Signature ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRoot((ImmutableList<Signature>)newValue, this.signedMeta);
    }

    public final ImmutableRoot withSignatures(Iterable<? extends Signature> elements) {
        if (this.signatures == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRoot((ImmutableList<Signature>)newValue, this.signedMeta);
    }

    public final ImmutableRoot withSignedMeta(RootMeta value) {
        if (this.signedMeta == value) {
            return this;
        }
        RootMeta newValue = Objects.requireNonNull(value, "signedMeta");
        return new ImmutableRoot(this.signatures, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRoot && this.equalTo(0, (ImmutableRoot)another);
    }

    private boolean equalTo(int synthetic, ImmutableRoot another) {
        return this.signatures.equals(another.signatures) && this.signedMeta.equals(another.signedMeta);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.signatures.hashCode();
        h += (h << 5) + this.signedMeta.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Root").omitNullValues().add("signatures", this.signatures).add("signedMeta", (Object)this.signedMeta).toString();
    }

    public static ImmutableRoot copyOf(Root instance) {
        if (instance instanceof ImmutableRoot) {
            return (ImmutableRoot)instance;
        }
        return ImmutableRoot.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Root", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SIGNED_META = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<Signature> signatures = ImmutableList.builder();
        @Nullable
        private RootMeta signedMeta;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Root instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllSignatures(instance.getSignatures());
            this.signedMeta(instance.getSignedMeta());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSignatures(Signature element) {
            this.signatures.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSignatures(Signature ... elements) {
            this.signatures.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signatures(Iterable<? extends Signature> elements) {
            this.signatures = ImmutableList.builder();
            return this.addAllSignatures(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSignatures(Iterable<? extends Signature> elements) {
            this.signatures.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signedMeta(RootMeta signedMeta) {
            this.signedMeta = Objects.requireNonNull(signedMeta, "signedMeta");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableRoot build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRoot((ImmutableList<Signature>)this.signatures.build(), this.signedMeta);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("signedMeta");
            }
            return "Cannot build Root, some of required attributes are not set " + attributes;
        }
    }
}

