/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.model;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import dev.sigstore.tuf.model.ImmutableKey;
import dev.sigstore.tuf.model.Key;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="dev.sigstore.tuf.model", generator="Gsons")
public final class GsonAdaptersKey
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (KeyTypeAdapter.adapts(type)) {
            return new KeyTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersKey(Key)";
    }

    @Generated(from="Key", generator="Gsons")
    private static class KeyTypeAdapter
    extends TypeAdapter<Key> {
        KeyTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return Key.class == type.getRawType() || ImmutableKey.class == type.getRawType();
        }

        public void write(JsonWriter out, Key value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeKey(out, value);
            }
        }

        public Key read(JsonReader in) throws IOException {
            return this.readKey(in);
        }

        private void writeKey(JsonWriter out, Key instance) throws IOException {
            out.beginObject();
            List<String> keyIdHashAlgorithmsElements = instance.getKeyIdHashAlgorithms();
            out.name("keyid_hash_algorithms");
            out.beginArray();
            for (String e : keyIdHashAlgorithmsElements) {
                out.value(e);
            }
            out.endArray();
            out.name("keytype");
            out.value(instance.getKeyType());
            Map<String, String> keyValMapping = instance.getKeyVal();
            out.name("keyval");
            out.beginObject();
            for (Map.Entry<String, String> e : keyValMapping.entrySet()) {
                String key = e.getKey();
                out.name(key);
                String value = e.getValue();
                out.value(value);
            }
            out.endObject();
            out.name("scheme");
            out.value(instance.getScheme());
            out.endObject();
        }

        private Key readKey(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableKey.Builder builder = ImmutableKey.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableKey.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'k': {
                    if ("keyid_hash_algorithms".equals(attributeName)) {
                        this.readInKeyIdHashAlgorithms(in, builder);
                        return;
                    }
                    if ("keytype".equals(attributeName)) {
                        this.readInKeyType(in, builder);
                        return;
                    }
                    if (!"keyval".equals(attributeName)) break;
                    this.readInKeyVal(in, builder);
                    return;
                }
                case 's': {
                    if (!"scheme".equals(attributeName)) break;
                    this.readInScheme(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInKeyIdHashAlgorithms(JsonReader in, ImmutableKey.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    builder.addKeyIdHashAlgorithms(in.nextString());
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.addKeyIdHashAlgorithms(in.nextString());
            }
        }

        private void readInKeyType(JsonReader in, ImmutableKey.Builder builder) throws IOException {
            builder.keyType(in.nextString());
        }

        private void readInKeyVal(JsonReader in, ImmutableKey.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    String value = in.nextString();
                    builder.putKeyVal(key, value);
                }
                in.endObject();
            }
        }

        private void readInScheme(JsonReader in, ImmutableKey.Builder builder) throws IOException {
            builder.scheme(in.nextString());
        }
    }
}

