/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.ObjectParser;
import dev.sigstore.http.HttpClients;
import dev.sigstore.http.ImmutableHttpParams;
import dev.sigstore.json.GsonSupplier;
import dev.sigstore.tuf.FileExceedsMaxLengthException;
import dev.sigstore.tuf.MetaFetchResult;
import dev.sigstore.tuf.MetaFetcher;
import dev.sigstore.tuf.TufException;
import dev.sigstore.tuf.model.Role;
import dev.sigstore.tuf.model.Root;
import dev.sigstore.tuf.model.SignedTufMeta;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Optional;

public class HttpMetaFetcher
implements MetaFetcher {
    private static final int MAX_META_BYTES = 101376;
    private final URL mirror;

    HttpMetaFetcher(URL mirror) {
        this.mirror = mirror;
    }

    public static HttpMetaFetcher newFetcher(URL mirror) {
        return new HttpMetaFetcher(mirror);
    }

    @Override
    public String getSource() {
        return this.mirror.toString();
    }

    @Override
    public Optional<MetaFetchResult<Root>> getRootAtVersion(int version) throws IOException, FileExceedsMaxLengthException {
        String versionFileName = version + ".root.json";
        return this.getMeta(versionFileName, Root.class, null);
    }

    @Override
    public <T extends SignedTufMeta> Optional<MetaFetchResult<T>> getMeta(Role.Name role, Class<T> t) throws IOException, FileExceedsMaxLengthException {
        return this.getMeta(role, t, null);
    }

    @Override
    public <T extends SignedTufMeta> Optional<MetaFetchResult<T>> getMeta(Role.Name role, Class<T> t, Integer maxSize) throws IOException, FileExceedsMaxLengthException {
        String fileName = role.name().toLowerCase(Locale.ROOT) + ".json";
        return this.getMeta(fileName, t, maxSize);
    }

    <T extends SignedTufMeta> Optional<MetaFetchResult<T>> getMeta(String filename, Class<T> t, Integer maxSize) throws IOException, FileExceedsMaxLengthException {
        byte[] roleBytes = this.fetchResource(filename, maxSize == null ? 101376 : maxSize);
        if (roleBytes == null) {
            return Optional.empty();
        }
        MetaFetchResult<SignedTufMeta> result = new MetaFetchResult<SignedTufMeta>(roleBytes, (SignedTufMeta)GsonSupplier.GSON.get().fromJson(new String(roleBytes, StandardCharsets.UTF_8), t));
        return Optional.of(result);
    }

    @Override
    public byte[] fetchResource(String filename, int maxLength) throws IOException, FileExceedsMaxLengthException {
        GenericUrl fileUrl = new GenericUrl(this.mirror + "/" + filename);
        HttpRequest req = HttpClients.newHttpTransport(ImmutableHttpParams.builder().build()).createRequestFactory(request -> request.setParser((ObjectParser)GsonFactory.getDefaultInstance().createJsonObjectParser())).buildGetRequest(fileUrl);
        req.getHeaders().setAccept("application/json; api-version=2.0");
        req.getHeaders().setContentType("application/json");
        req.setThrowExceptionOnExecuteError(false);
        HttpResponse resp = req.execute();
        if (resp.getStatusCode() == 404) {
            return null;
        }
        if (resp.getStatusCode() != 200) {
            throw new TufException(String.format(Locale.ROOT, "Unexpected return from mirror(%s). Status code: %s, status message: %s", this.mirror, resp.getStatusCode(), resp.getStatusMessage()));
        }
        byte[] roleBytes = resp.getContent().readNBytes(maxLength);
        if (roleBytes.length == maxLength && resp.getContent().read() != -1) {
            throw new FileExceedsMaxLengthException(fileUrl.toString(), maxLength);
        }
        return roleBytes;
    }
}

