/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import com.google.common.hash.Hashing;
import dev.sigstore.encryption.Keys;
import dev.sigstore.encryption.signers.Verifier;
import dev.sigstore.encryption.signers.Verifiers;
import dev.sigstore.rekor.client.RekorEntry;
import dev.sigstore.rekor.client.RekorVerificationException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class RekorVerifier {
    private final Verifier verifier;
    private final String calculatedLogId;

    public static RekorVerifier newRekorVerifier(byte[] rekorPublicKey) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException {
        PublicKey publicKey = Keys.parsePublicKey(rekorPublicKey);
        Verifier verifier = Verifiers.newVerifier(publicKey);
        return new RekorVerifier(verifier);
    }

    private RekorVerifier(Verifier verifier) {
        this.calculatedLogId = Hashing.sha256().hashBytes(verifier.getPublicKey().getEncoded()).toString();
        this.verifier = verifier;
    }

    public void verifyEntry(RekorEntry entry) throws RekorVerificationException {
        if (entry.getVerification() == null) {
            throw new RekorVerificationException("No verification information in entry.");
        }
        if (entry.getVerification().getSignedEntryTimestamp() == null) {
            throw new RekorVerificationException("No signed entry timestamp found in entry.");
        }
        if (!entry.getLogID().equals(this.calculatedLogId)) {
            throw new RekorVerificationException("LogId does not match supplied rekor public key.");
        }
        try {
            if (!this.verifier.verify(entry.getSignableContent(), Base64.getDecoder().decode(entry.getVerification().getSignedEntryTimestamp()))) {
                throw new RekorVerificationException("Entry SET was not valid");
            }
        }
        catch (InvalidKeyException ike) {
            throw new RekorVerificationException("Public Key was invalid", ike);
        }
        catch (SignatureException se) {
            throw new RekorVerificationException("Signature was invalid", se);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new AssertionError((Object)"Required verification algorithm 'SHA256withECDSA' not found.");
        }
    }

    public void verifyInclusionProof(RekorEntry entry) throws RekorVerificationException {
        RekorEntry.InclusionProof inclusionProof = entry.getVerification().getInclusionProof().orElseThrow(() -> new RekorVerificationException("No inclusion proof was found in the rekor entry"));
        byte[] leafHash = Hashing.sha256().hashBytes(RekorVerifier.combineBytes(new byte[]{0}, Base64.getDecoder().decode(entry.getBody()))).asBytes();
        Long nodeIndex = inclusionProof.getLogIndex();
        long totalNodes = inclusionProof.getTreeSize() - 1L;
        byte[] currentHash = leafHash;
        List<String> hashes = inclusionProof.getHashes();
        for (String hash : hashes) {
            byte[] p = Hex.decode((String)hash);
            if (totalNodes == 0L) {
                throw new RekorVerificationException("Inclusion proof failed, ended prematurely");
            }
            if (nodeIndex == totalNodes || nodeIndex % 2L == 1L) {
                currentHash = RekorVerifier.hashChildren(p, currentHash);
                while (nodeIndex % 2L == 0L) {
                    nodeIndex = nodeIndex >> 1;
                    totalNodes >>= 1;
                }
            } else {
                currentHash = RekorVerifier.hashChildren(currentHash, p);
            }
            nodeIndex = nodeIndex >> 1;
            totalNodes >>= 1;
        }
        String calcuatedRootHash = Hex.toHexString((byte[])currentHash);
        if (!calcuatedRootHash.equals(inclusionProof.getRootHash())) {
            throw new RekorVerificationException("Calculated inclusion proof root hash does not match provided root hash\n" + calcuatedRootHash + "\n" + inclusionProof.getRootHash());
        }
    }

    private static byte[] combineBytes(byte[] first, byte[] second) {
        byte[] result = new byte[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private static byte[] hashChildren(byte[] left, byte[] right) {
        return Hashing.sha256().hashBytes(RekorVerifier.combineBytes(new byte[]{1}, RekorVerifier.combineBytes(left, right))).asBytes();
    }
}

