/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import dev.sigstore.json.GsonSupplier;
import dev.sigstore.rekor.HashedRekord;
import dev.sigstore.rekor.client.RekorEntry;
import dev.sigstore.rekor.client.RekorTypeException;

public class RekorTypes {
    public static HashedRekord getHashedRekord(RekorEntry entry) throws RekorTypeException {
        RekorTypes.expect(entry, "hashedrekord", "0.0.1");
        return (HashedRekord)GsonSupplier.GSON.get().fromJson(entry.getBodyDecoded().getSpec(), HashedRekord.class);
    }

    private static void expect(RekorEntry entry, String expectedKind, String expectedApiVersion) throws RekorTypeException {
        String kind = entry.getBodyDecoded().getKind();
        String apiVersion = entry.getBodyDecoded().getApiVersion();
        if (!kind.equals(expectedKind) || !apiVersion.equals(expectedApiVersion)) {
            throw new RekorTypeException("Expecting type " + expectedKind + ":" + expectedApiVersion + ", but found " + kind + ":" + apiVersion);
        }
    }
}

