/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import com.google.common.reflect.TypeToken;
import dev.sigstore.json.GsonSupplier;
import dev.sigstore.rekor.client.ImmutableRekorResponse;
import dev.sigstore.rekor.client.RekorEntry;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Map;
import org.immutables.value.Value;

@Value.Immutable
public interface RekorResponse {
    public static RekorResponse newRekorResponse(URI entryLocation, String rawResponse) {
        Type type = new TypeToken<Map<String, RekorEntry>>(){}.getType();
        Map entryMap = (Map)GsonSupplier.GSON.get().fromJson(rawResponse, type);
        if (entryMap.size() != 1) {
            throw new IllegalArgumentException("Expecting a single rekor entry in response but found: " + entryMap.size());
        }
        Map.Entry entry = entryMap.entrySet().iterator().next();
        return ImmutableRekorResponse.builder().entryLocation(entryLocation).raw(rawResponse).uuid((String)entry.getKey()).entry((RekorEntry)entry.getValue()).build();
    }

    public URI getEntryLocation();

    public RekorEntry getEntry();

    public String getUuid();

    public String getRaw();
}

