/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import dev.sigstore.http.HttpClients;
import dev.sigstore.http.HttpParams;
import dev.sigstore.http.ImmutableHttpParams;
import dev.sigstore.json.GsonSupplier;
import dev.sigstore.rekor.client.HashedRekordRequest;
import dev.sigstore.rekor.client.RekorEntry;
import dev.sigstore.rekor.client.RekorResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class RekorClient {
    public static final String PUBLIC_REKOR_SERVER = "https://rekor.sigstore.dev";
    public static final String STAGING_REKOR_SERVER = "https://rekor.sigstage.dev";
    public static final String REKOR_ENTRIES_PATH = "/api/v1/log/entries";
    public static final String REKOR_INDEX_SEARCH_PATH = "/api/v1/index/retrieve";
    private final HttpParams httpParams;
    private final URI serverUrl;

    public static Builder builder() {
        return new Builder();
    }

    private RekorClient(HttpParams httpParams, URI serverUrl) {
        this.serverUrl = serverUrl;
        this.httpParams = httpParams;
    }

    public RekorResponse putEntry(HashedRekordRequest hashedRekordRequest) throws IOException {
        URI rekorPutEndpoint = this.serverUrl.resolve(REKOR_ENTRIES_PATH);
        HttpRequest req = HttpClients.newRequestFactory(this.httpParams).buildPostRequest(new GenericUrl(rekorPutEndpoint), (HttpContent)ByteArrayContent.fromString((String)"application/json", (String)hashedRekordRequest.toJsonPayload()));
        req.getHeaders().set("Accept", (Object)"application/json");
        req.getHeaders().set("Content-Type", (Object)"application/json");
        HttpResponse resp = req.execute();
        if (resp.getStatusCode() != 201) {
            throw new IOException(String.format(Locale.ROOT, "bad response from rekor @ '%s' : %s", rekorPutEndpoint, resp.parseAsString()));
        }
        URI rekorEntryUri = this.serverUrl.resolve(resp.getHeaders().getLocation());
        String entry = resp.parseAsString();
        return RekorResponse.newRekorResponse(rekorEntryUri, entry);
    }

    public Optional<RekorEntry> getEntry(HashedRekordRequest hashedRekordRequest) throws IOException {
        return this.getEntry(hashedRekordRequest.computeUUID());
    }

    public Optional<RekorEntry> getEntry(String UUID) throws IOException {
        HttpResponse response;
        URI getEntryURI = this.serverUrl.resolve("/api/v1/log/entries/" + UUID);
        HttpRequest req = HttpClients.newRequestFactory(this.httpParams).buildGetRequest(new GenericUrl(getEntryURI));
        req.getHeaders().set("Accept", (Object)"application/json");
        try {
            response = req.execute();
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return Optional.empty();
            }
            throw e;
        }
        return Optional.of(RekorResponse.newRekorResponse(getEntryURI, response.parseAsString()).getEntry());
    }

    public List<String> searchEntry(String email, String hash, String publicKeyFormat, String publicKeyContent) throws IOException {
        URI rekorSearchEndpoint = this.serverUrl.resolve(REKOR_INDEX_SEARCH_PATH);
        HashMap<String, String> publicKeyParams = null;
        if (publicKeyContent != null) {
            publicKeyParams = new HashMap<String, String>();
            publicKeyParams.put("format", publicKeyFormat);
            publicKeyParams.put("content", publicKeyContent);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("email", email);
        data.put("hash", hash);
        data.put("publicKey", publicKeyParams);
        String contentString = GsonSupplier.GSON.get().toJson(data);
        HttpRequest req = HttpClients.newRequestFactory(this.httpParams).buildPostRequest(new GenericUrl(rekorSearchEndpoint), (HttpContent)ByteArrayContent.fromString((String)"application/json", (String)contentString));
        req.getHeaders().set("Accept", (Object)"application/json");
        req.getHeaders().set("Content-Type", (Object)"application/json");
        HttpResponse response = req.execute();
        return Arrays.asList((String[])GsonSupplier.GSON.get().fromJson(response.parseAsString(), String[].class));
    }

    public static class Builder {
        private URI serverUrl = URI.create("https://rekor.sigstore.dev");
        private HttpParams httpParams = ImmutableHttpParams.builder().build();

        private Builder() {
        }

        public Builder setHttpParams(HttpParams httpParams) {
            this.httpParams = httpParams;
            return this;
        }

        public Builder setServerUrl(URI uri) {
            this.serverUrl = uri;
            return this;
        }

        public RekorClient build() {
            return new RekorClient(this.httpParams, this.serverUrl);
        }
    }
}

