/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.rekor.client.RekorEntry;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RekorEntry.Verification", generator="Immutables")
@Immutable
public final class ImmutableVerification
implements RekorEntry.Verification {
    private final String signedEntryTimestamp;
    @Nullable
    private final RekorEntry.InclusionProof inclusionProof;

    private ImmutableVerification(String signedEntryTimestamp, @Nullable RekorEntry.InclusionProof inclusionProof) {
        this.signedEntryTimestamp = signedEntryTimestamp;
        this.inclusionProof = inclusionProof;
    }

    @Override
    public String getSignedEntryTimestamp() {
        return this.signedEntryTimestamp;
    }

    @Override
    public Optional<RekorEntry.InclusionProof> getInclusionProof() {
        return Optional.ofNullable(this.inclusionProof);
    }

    public final ImmutableVerification withSignedEntryTimestamp(String value) {
        String newValue = Objects.requireNonNull(value, "signedEntryTimestamp");
        if (this.signedEntryTimestamp.equals(newValue)) {
            return this;
        }
        return new ImmutableVerification(newValue, this.inclusionProof);
    }

    public final ImmutableVerification withInclusionProof(RekorEntry.InclusionProof value) {
        RekorEntry.InclusionProof newValue = Objects.requireNonNull(value, "inclusionProof");
        if (this.inclusionProof == newValue) {
            return this;
        }
        return new ImmutableVerification(this.signedEntryTimestamp, newValue);
    }

    public final ImmutableVerification withInclusionProof(Optional<? extends RekorEntry.InclusionProof> optional) {
        RekorEntry.InclusionProof value = optional.orElse(null);
        if (this.inclusionProof == value) {
            return this;
        }
        return new ImmutableVerification(this.signedEntryTimestamp, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVerification && this.equalTo(0, (ImmutableVerification)another);
    }

    private boolean equalTo(int synthetic, ImmutableVerification another) {
        return this.signedEntryTimestamp.equals(another.signedEntryTimestamp) && Objects.equals(this.inclusionProof, another.inclusionProof);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.signedEntryTimestamp.hashCode();
        h += (h << 5) + Objects.hashCode(this.inclusionProof);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Verification").omitNullValues().add("signedEntryTimestamp", (Object)this.signedEntryTimestamp).add("inclusionProof", (Object)this.inclusionProof).toString();
    }

    public static ImmutableVerification copyOf(RekorEntry.Verification instance) {
        if (instance instanceof ImmutableVerification) {
            return (ImmutableVerification)instance;
        }
        return ImmutableVerification.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RekorEntry.Verification", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SIGNED_ENTRY_TIMESTAMP = 1L;
        private long initBits = 1L;
        @Nullable
        private String signedEntryTimestamp;
        @Nullable
        private RekorEntry.InclusionProof inclusionProof;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RekorEntry.Verification instance) {
            Objects.requireNonNull(instance, "instance");
            this.signedEntryTimestamp(instance.getSignedEntryTimestamp());
            Optional<RekorEntry.InclusionProof> inclusionProofOptional = instance.getInclusionProof();
            if (inclusionProofOptional.isPresent()) {
                this.inclusionProof(inclusionProofOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signedEntryTimestamp(String signedEntryTimestamp) {
            this.signedEntryTimestamp = Objects.requireNonNull(signedEntryTimestamp, "signedEntryTimestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder inclusionProof(RekorEntry.InclusionProof inclusionProof) {
            this.inclusionProof = Objects.requireNonNull(inclusionProof, "inclusionProof");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder inclusionProof(Optional<? extends RekorEntry.InclusionProof> inclusionProof) {
            this.inclusionProof = inclusionProof.orElse(null);
            return this;
        }

        public ImmutableVerification build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableVerification(this.signedEntryTimestamp, this.inclusionProof);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("signedEntryTimestamp");
            }
            return "Cannot build Verification, some of required attributes are not set " + attributes;
        }
    }
}

