/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.rekor.client.RekorEntry;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RekorEntry.InclusionProof", generator="Immutables")
@Immutable
public final class ImmutableInclusionProof
implements RekorEntry.InclusionProof {
    private final ImmutableList<String> hashes;
    private final Long logIndex;
    private final String rootHash;
    private final Long treeSize;
    private final String checkpoint;

    private ImmutableInclusionProof(ImmutableList<String> hashes, Long logIndex, String rootHash, Long treeSize, String checkpoint) {
        this.hashes = hashes;
        this.logIndex = logIndex;
        this.rootHash = rootHash;
        this.treeSize = treeSize;
        this.checkpoint = checkpoint;
    }

    public ImmutableList<String> getHashes() {
        return this.hashes;
    }

    @Override
    public Long getLogIndex() {
        return this.logIndex;
    }

    @Override
    public String getRootHash() {
        return this.rootHash;
    }

    @Override
    public Long getTreeSize() {
        return this.treeSize;
    }

    @Override
    public String getCheckpoint() {
        return this.checkpoint;
    }

    public final ImmutableInclusionProof withHashes(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableInclusionProof((ImmutableList<String>)newValue, this.logIndex, this.rootHash, this.treeSize, this.checkpoint);
    }

    public final ImmutableInclusionProof withHashes(Iterable<String> elements) {
        if (this.hashes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableInclusionProof((ImmutableList<String>)newValue, this.logIndex, this.rootHash, this.treeSize, this.checkpoint);
    }

    public final ImmutableInclusionProof withLogIndex(Long value) {
        Long newValue = Objects.requireNonNull(value, "logIndex");
        if (this.logIndex.equals(newValue)) {
            return this;
        }
        return new ImmutableInclusionProof(this.hashes, newValue, this.rootHash, this.treeSize, this.checkpoint);
    }

    public final ImmutableInclusionProof withRootHash(String value) {
        String newValue = Objects.requireNonNull(value, "rootHash");
        if (this.rootHash.equals(newValue)) {
            return this;
        }
        return new ImmutableInclusionProof(this.hashes, this.logIndex, newValue, this.treeSize, this.checkpoint);
    }

    public final ImmutableInclusionProof withTreeSize(Long value) {
        Long newValue = Objects.requireNonNull(value, "treeSize");
        if (this.treeSize.equals(newValue)) {
            return this;
        }
        return new ImmutableInclusionProof(this.hashes, this.logIndex, this.rootHash, newValue, this.checkpoint);
    }

    public final ImmutableInclusionProof withCheckpoint(String value) {
        String newValue = Objects.requireNonNull(value, "checkpoint");
        if (this.checkpoint.equals(newValue)) {
            return this;
        }
        return new ImmutableInclusionProof(this.hashes, this.logIndex, this.rootHash, this.treeSize, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInclusionProof && this.equalTo(0, (ImmutableInclusionProof)another);
    }

    private boolean equalTo(int synthetic, ImmutableInclusionProof another) {
        return this.hashes.equals(another.hashes) && this.logIndex.equals(another.logIndex) && this.rootHash.equals(another.rootHash) && this.treeSize.equals(another.treeSize) && this.checkpoint.equals(another.checkpoint);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.hashes.hashCode();
        h += (h << 5) + this.logIndex.hashCode();
        h += (h << 5) + this.rootHash.hashCode();
        h += (h << 5) + this.treeSize.hashCode();
        h += (h << 5) + this.checkpoint.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"InclusionProof").omitNullValues().add("hashes", this.hashes).add("logIndex", (Object)this.logIndex).add("rootHash", (Object)this.rootHash).add("treeSize", (Object)this.treeSize).add("checkpoint", (Object)this.checkpoint).toString();
    }

    public static ImmutableInclusionProof copyOf(RekorEntry.InclusionProof instance) {
        if (instance instanceof ImmutableInclusionProof) {
            return (ImmutableInclusionProof)instance;
        }
        return ImmutableInclusionProof.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RekorEntry.InclusionProof", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LOG_INDEX = 1L;
        private static final long INIT_BIT_ROOT_HASH = 2L;
        private static final long INIT_BIT_TREE_SIZE = 4L;
        private static final long INIT_BIT_CHECKPOINT = 8L;
        private long initBits = 15L;
        private ImmutableList.Builder<String> hashes = ImmutableList.builder();
        @Nullable
        private Long logIndex;
        @Nullable
        private String rootHash;
        @Nullable
        private Long treeSize;
        @Nullable
        private String checkpoint;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RekorEntry.InclusionProof instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllHashes(instance.getHashes());
            this.logIndex(instance.getLogIndex());
            this.rootHash(instance.getRootHash());
            this.treeSize(instance.getTreeSize());
            this.checkpoint(instance.getCheckpoint());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addHashes(String element) {
            this.hashes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addHashes(String ... elements) {
            this.hashes.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hashes(Iterable<String> elements) {
            this.hashes = ImmutableList.builder();
            return this.addAllHashes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllHashes(Iterable<String> elements) {
            this.hashes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder logIndex(Long logIndex) {
            this.logIndex = Objects.requireNonNull(logIndex, "logIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rootHash(String rootHash) {
            this.rootHash = Objects.requireNonNull(rootHash, "rootHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder treeSize(Long treeSize) {
            this.treeSize = Objects.requireNonNull(treeSize, "treeSize");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder checkpoint(String checkpoint) {
            this.checkpoint = Objects.requireNonNull(checkpoint, "checkpoint");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableInclusionProof build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInclusionProof((ImmutableList<String>)this.hashes.build(), this.logIndex, this.rootHash, this.treeSize, this.checkpoint);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("logIndex");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("rootHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("treeSize");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("checkpoint");
            }
            return "Cannot build InclusionProof, some of required attributes are not set " + attributes;
        }
    }
}

