/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import dev.sigstore.rekor.client.ImmutableInclusionProof;
import dev.sigstore.rekor.client.ImmutableRekorEntry;
import dev.sigstore.rekor.client.ImmutableVerification;
import dev.sigstore.rekor.client.RekorEntry;
import dev.sigstore.rekor.client.RekorEntryBody;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="dev.sigstore.rekor.client", generator="Gsons")
public final class GsonAdaptersRekorEntry
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (InclusionProofTypeAdapter.adapts(type)) {
            return new InclusionProofTypeAdapter(gson);
        }
        if (RekorEntryTypeAdapter.adapts(type)) {
            return new RekorEntryTypeAdapter(gson);
        }
        if (VerificationTypeAdapter.adapts(type)) {
            return new VerificationTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersRekorEntry(InclusionProof, RekorEntry, Verification)";
    }

    @Generated(from="RekorEntry.Verification", generator="Gsons")
    private static class VerificationTypeAdapter
    extends TypeAdapter<RekorEntry.Verification> {
        public final RekorEntry.InclusionProof inclusionProofTypeSample = null;
        private final TypeAdapter<RekorEntry.InclusionProof> inclusionProofTypeAdapter;

        VerificationTypeAdapter(Gson gson) {
            this.inclusionProofTypeAdapter = gson.getAdapter(RekorEntry.InclusionProof.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return RekorEntry.Verification.class == type.getRawType() || ImmutableVerification.class == type.getRawType();
        }

        public void write(JsonWriter out, RekorEntry.Verification value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeVerification(out, value);
            }
        }

        public RekorEntry.Verification read(JsonReader in) throws IOException {
            return this.readVerification(in);
        }

        private void writeVerification(JsonWriter out, RekorEntry.Verification instance) throws IOException {
            out.beginObject();
            out.name("signedEntryTimestamp");
            out.value(instance.getSignedEntryTimestamp());
            Optional<RekorEntry.InclusionProof> inclusionProofOptional = instance.getInclusionProof();
            if (inclusionProofOptional.isPresent()) {
                out.name("inclusionProof");
                RekorEntry.InclusionProof inclusionProofValue = inclusionProofOptional.get();
                this.inclusionProofTypeAdapter.write(out, (Object)inclusionProofValue);
            } else if (out.getSerializeNulls()) {
                out.name("inclusionProof");
                out.nullValue();
            }
            out.endObject();
        }

        private RekorEntry.Verification readVerification(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableVerification.Builder builder = ImmutableVerification.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableVerification.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 's': {
                    if (!"signedEntryTimestamp".equals(attributeName)) break;
                    this.readInSignedEntryTimestamp(in, builder);
                    return;
                }
                case 'i': {
                    if (!"inclusionProof".equals(attributeName)) break;
                    this.readInInclusionProof(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInSignedEntryTimestamp(JsonReader in, ImmutableVerification.Builder builder) throws IOException {
            builder.signedEntryTimestamp(in.nextString());
        }

        private void readInInclusionProof(JsonReader in, ImmutableVerification.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                RekorEntry.InclusionProof value = (RekorEntry.InclusionProof)this.inclusionProofTypeAdapter.read(in);
                builder.inclusionProof(value);
            }
        }
    }

    @Generated(from="RekorEntry", generator="Gsons")
    private static class RekorEntryTypeAdapter
    extends TypeAdapter<RekorEntry> {
        public final RekorEntryBody bodyDecodedTypeSample = null;
        public final RekorEntry.Verification verificationTypeSample = null;
        private final TypeAdapter<RekorEntryBody> bodyDecodedTypeAdapter;
        private final TypeAdapter<RekorEntry.Verification> verificationTypeAdapter;

        RekorEntryTypeAdapter(Gson gson) {
            this.bodyDecodedTypeAdapter = gson.getAdapter(RekorEntryBody.class);
            this.verificationTypeAdapter = gson.getAdapter(RekorEntry.Verification.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return RekorEntry.class == type.getRawType() || ImmutableRekorEntry.class == type.getRawType();
        }

        public void write(JsonWriter out, RekorEntry value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeRekorEntry(out, value);
            }
        }

        public RekorEntry read(JsonReader in) throws IOException {
            return this.readRekorEntry(in);
        }

        private void writeRekorEntry(JsonWriter out, RekorEntry instance) throws IOException {
            out.beginObject();
            out.name("body");
            out.value(instance.getBody());
            out.name("bodyDecoded");
            this.bodyDecodedTypeAdapter.write(out, (Object)instance.getBodyDecoded());
            out.name("integratedTime");
            out.value(instance.getIntegratedTime());
            out.name("logID");
            out.value(instance.getLogID());
            out.name("logIndex");
            out.value(instance.getLogIndex());
            out.name("verification");
            this.verificationTypeAdapter.write(out, (Object)instance.getVerification());
            out.endObject();
        }

        private RekorEntry readRekorEntry(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableRekorEntry.Builder builder = ImmutableRekorEntry.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableRekorEntry.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'b': {
                    if (!"body".equals(attributeName)) break;
                    this.readInBody(in, builder);
                    return;
                }
                case 'i': {
                    if (!"integratedTime".equals(attributeName)) break;
                    this.readInIntegratedTime(in, builder);
                    return;
                }
                case 'l': {
                    if ("logID".equals(attributeName)) {
                        this.readInLogID(in, builder);
                        return;
                    }
                    if (!"logIndex".equals(attributeName)) break;
                    this.readInLogIndex(in, builder);
                    return;
                }
                case 'v': {
                    if (!"verification".equals(attributeName)) break;
                    this.readInVerification(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInBody(JsonReader in, ImmutableRekorEntry.Builder builder) throws IOException {
            builder.body(in.nextString());
        }

        private void readInIntegratedTime(JsonReader in, ImmutableRekorEntry.Builder builder) throws IOException {
            builder.integratedTime(in.nextLong());
        }

        private void readInLogID(JsonReader in, ImmutableRekorEntry.Builder builder) throws IOException {
            builder.logID(in.nextString());
        }

        private void readInLogIndex(JsonReader in, ImmutableRekorEntry.Builder builder) throws IOException {
            builder.logIndex(in.nextLong());
        }

        private void readInVerification(JsonReader in, ImmutableRekorEntry.Builder builder) throws IOException {
            RekorEntry.Verification value = (RekorEntry.Verification)this.verificationTypeAdapter.read(in);
            builder.verification(value);
        }
    }

    @Generated(from="RekorEntry.InclusionProof", generator="Gsons")
    private static class InclusionProofTypeAdapter
    extends TypeAdapter<RekorEntry.InclusionProof> {
        public final Long logIndexTypeSample = null;
        public final Long treeSizeTypeSample = null;
        private final TypeAdapter<Long> logIndexTypeAdapter;
        private final TypeAdapter<Long> treeSizeTypeAdapter;

        InclusionProofTypeAdapter(Gson gson) {
            this.logIndexTypeAdapter = gson.getAdapter(Long.class);
            this.treeSizeTypeAdapter = gson.getAdapter(Long.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return RekorEntry.InclusionProof.class == type.getRawType() || ImmutableInclusionProof.class == type.getRawType();
        }

        public void write(JsonWriter out, RekorEntry.InclusionProof value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeInclusionProof(out, value);
            }
        }

        public RekorEntry.InclusionProof read(JsonReader in) throws IOException {
            return this.readInclusionProof(in);
        }

        private void writeInclusionProof(JsonWriter out, RekorEntry.InclusionProof instance) throws IOException {
            out.beginObject();
            List<String> hashesElements = instance.getHashes();
            out.name("hashes");
            out.beginArray();
            for (String e : hashesElements) {
                out.value(e);
            }
            out.endArray();
            out.name("logIndex");
            this.logIndexTypeAdapter.write(out, (Object)instance.getLogIndex());
            out.name("rootHash");
            out.value(instance.getRootHash());
            out.name("treeSize");
            this.treeSizeTypeAdapter.write(out, (Object)instance.getTreeSize());
            out.name("checkpoint");
            out.value(instance.getCheckpoint());
            out.endObject();
        }

        private RekorEntry.InclusionProof readInclusionProof(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableInclusionProof.Builder builder = ImmutableInclusionProof.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableInclusionProof.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'h': {
                    if (!"hashes".equals(attributeName)) break;
                    this.readInHashes(in, builder);
                    return;
                }
                case 'l': {
                    if (!"logIndex".equals(attributeName)) break;
                    this.readInLogIndex(in, builder);
                    return;
                }
                case 'r': {
                    if (!"rootHash".equals(attributeName)) break;
                    this.readInRootHash(in, builder);
                    return;
                }
                case 't': {
                    if (!"treeSize".equals(attributeName)) break;
                    this.readInTreeSize(in, builder);
                    return;
                }
                case 'c': {
                    if (!"checkpoint".equals(attributeName)) break;
                    this.readInCheckpoint(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInHashes(JsonReader in, ImmutableInclusionProof.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    builder.addHashes(in.nextString());
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.addHashes(in.nextString());
            }
        }

        private void readInLogIndex(JsonReader in, ImmutableInclusionProof.Builder builder) throws IOException {
            Long value = (Long)this.logIndexTypeAdapter.read(in);
            builder.logIndex(value);
        }

        private void readInRootHash(JsonReader in, ImmutableInclusionProof.Builder builder) throws IOException {
            builder.rootHash(in.nextString());
        }

        private void readInTreeSize(JsonReader in, ImmutableInclusionProof.Builder builder) throws IOException {
            Long value = (Long)this.treeSizeTypeAdapter.read(in);
            builder.treeSize(value);
        }

        private void readInCheckpoint(JsonReader in, ImmutableInclusionProof.Builder builder) throws IOException {
            builder.checkpoint(in.nextString());
        }
    }
}

