/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.json;

import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Base64;

class GsonByteArrayAdapter
extends TypeAdapter<byte[]> {
    GsonByteArrayAdapter() {
    }

    public void write(JsonWriter out, byte[] value) throws IOException {
        out.value(new String(Base64.getEncoder().encodeToString(value)));
    }

    public byte[] read(JsonReader in) {
        try {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return new byte[0];
            }
            String byteValue = in.nextString();
            if (byteValue != null) {
                return Base64.getDecoder().decode(byteValue);
            }
            return new byte[0];
        }
        catch (Exception e) {
            throw new JsonParseException((Throwable)e);
        }
    }
}

