/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.fulcio.client;

import com.google.api.client.util.PemReader;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonParseException;
import com.google.protobuf.ByteString;
import dev.sigstore.encryption.certificates.transparency.DigitallySigned;
import dev.sigstore.encryption.certificates.transparency.SerializationException;
import dev.sigstore.encryption.certificates.transparency.SignedCertificateTimestamp;
import dev.sigstore.fulcio.v2.CertificateChain;
import dev.sigstore.fulcio.v2.SigningCertificateDetachedSCT;
import dev.sigstore.fulcio.v2.SigningCertificateEmbeddedSCT;
import dev.sigstore.json.GsonSupplier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public class SigningCertificate {
    private static final String SCT_X509_OID = "1.3.6.1.4.1.11129.2.4.2";
    private final CertPath certPath;
    @Nullable
    private final SignedCertificateTimestamp sct;

    public static SigningCertificate from(CertPath certPath) {
        return new SigningCertificate(certPath);
    }

    static SigningCertificate newSigningCertificate(String certs, @Nullable String sctHeader) throws CertificateException, IOException, SerializationException {
        CertPath certPath = SigningCertificate.decodeCerts(certs);
        if (sctHeader != null) {
            SignedCertificateTimestamp sct = SigningCertificate.decodeSCT(new String(Base64.getDecoder().decode(sctHeader), StandardCharsets.UTF_8));
            return new SigningCertificate(certPath, sct);
        }
        return new SigningCertificate(certPath, null);
    }

    static SigningCertificate newSigningCertificate(SigningCertificateDetachedSCT signingCertificate) throws CertificateException, SerializationException {
        SignedCertificateTimestamp sct = null;
        if (!signingCertificate.getSignedCertificateTimestamp().isEmpty()) {
            sct = SigningCertificate.decodeSCT(signingCertificate.getSignedCertificateTimestamp().toStringUtf8());
        }
        return new SigningCertificate(SigningCertificate.decodeCerts(signingCertificate.getChain()), sct);
    }

    static SigningCertificate newSigningCertificate(SigningCertificateEmbeddedSCT signingCertificate) throws CertificateException {
        return new SigningCertificate(SigningCertificate.decodeCerts(signingCertificate.getChain()));
    }

    @VisibleForTesting
    static CertPath decodeCerts(CertificateChain certChain) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        if (certChain.getCertificatesCount() == 0) {
            throw new CertificateParsingException("no valid PEM certificates were found in response from Fulcio");
        }
        for (ByteString cert : certChain.getCertificatesList().asByteStringList()) {
            certs.add((X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(cert.toByteArray())));
        }
        return certificateFactory.generateCertPath(certs);
    }

    @VisibleForTesting
    static CertPath decodeCerts(String content) throws CertificateException, IOException {
        PemReader.Section section;
        PemReader pemReader = new PemReader((Reader)new StringReader(content));
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        while ((section = pemReader.readNextSection()) != null) {
            byte[] certBytes = section.getBase64DecodedBytes();
            certList.add((X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBytes)));
        }
        if (certList.isEmpty()) {
            throw new CertificateParsingException("no valid PEM certificates were found in response from Fulcio");
        }
        return cf.generateCertPath(certList);
    }

    @VisibleForTesting
    static SignedCertificateTimestamp decodeSCT(String sctJson) throws SerializationException {
        return ((SctJson)GsonSupplier.GSON.get().fromJson(sctJson, SctJson.class)).toSct();
    }

    boolean hasEmbeddedSct() {
        return this.getLeafCertificate().getExtensionValue(SCT_X509_OID) != null;
    }

    private SigningCertificate(CertPath certPath, SignedCertificateTimestamp sct) {
        this.certPath = certPath;
        this.sct = sct;
    }

    private SigningCertificate(CertPath certPath) {
        this.certPath = certPath;
        this.sct = null;
    }

    public CertPath getCertPath() {
        return this.certPath;
    }

    public List<X509Certificate> getCertificates() {
        return this.certPath.getCertificates();
    }

    public X509Certificate getLeafCertificate() {
        return (X509Certificate)this.certPath.getCertificates().get(0);
    }

    Optional<SignedCertificateTimestamp> getDetachedSct() {
        return Optional.ofNullable(this.sct);
    }

    private static class SctJson {
        private int sct_version;
        private byte[] id;
        private long timestamp;
        private byte[] extensions;
        private byte[] signature;

        private SctJson() {
        }

        public SignedCertificateTimestamp toSct() throws JsonParseException, SerializationException {
            if (this.sct_version != 0) {
                throw new JsonParseException("Invalid SCT version:" + this.sct_version + ", only 0 (V1) is allowed");
            }
            if (this.extensions.length != 0) {
                throw new JsonParseException("SCT has extensions that cannot be handled by client:" + new String(this.extensions, StandardCharsets.UTF_8));
            }
            DigitallySigned digiSig = DigitallySigned.decode(this.signature);
            return new SignedCertificateTimestamp(SignedCertificateTimestamp.Version.V1, this.id, this.timestamp, this.extensions, digiSig, SignedCertificateTimestamp.Origin.OCSP_RESPONSE);
        }
    }
}

