/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.fulcio.client;

import dev.sigstore.encryption.Keys;
import dev.sigstore.encryption.certificates.transparency.CTLogInfo;
import dev.sigstore.encryption.certificates.transparency.CTVerificationResult;
import dev.sigstore.encryption.certificates.transparency.CTVerifier;
import dev.sigstore.encryption.certificates.transparency.CertificateEntry;
import dev.sigstore.encryption.certificates.transparency.VerifiedSCT;
import dev.sigstore.fulcio.client.FulcioVerificationException;
import dev.sigstore.fulcio.client.SigningCertificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FulcioVerifier {
    private final @Nullable CTVerifier ctVerifier;
    private final TrustAnchor fulcioRoot;

    public static FulcioVerifier newFulcioVerifier(byte[] fulcioRoot, List<byte[]> ctfePublicKeys) throws InvalidKeySpecException, NoSuchAlgorithmException, CertificateException, IOException, InvalidAlgorithmParameterException {
        ArrayList<PublicKey> ctfePublicKeyObjs = null;
        if (ctfePublicKeys != null && ctfePublicKeys.size() != 0) {
            ctfePublicKeyObjs = new ArrayList<PublicKey>();
            for (byte[] pk : ctfePublicKeys) {
                ctfePublicKeyObjs.add(Keys.parsePublicKey(pk));
            }
        }
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate fulcioRootObj = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(fulcioRoot));
        TrustAnchor fulcioRootTrustAnchor = new TrustAnchor(fulcioRootObj, null);
        new PKIXParameters(Collections.singleton(fulcioRootTrustAnchor));
        return new FulcioVerifier(fulcioRootTrustAnchor, ctfePublicKeyObjs);
    }

    private FulcioVerifier(TrustAnchor fulcioRoot, @Nullable List<PublicKey> ctfePublicKeys) {
        this.fulcioRoot = fulcioRoot;
        if (ctfePublicKeys != null) {
            ArrayList<CTLogInfo> logInfos = new ArrayList<CTLogInfo>();
            for (PublicKey pk : ctfePublicKeys) {
                CTLogInfo ctLogInfo = new CTLogInfo(pk, "fulcio ct log", "unused-url");
                logInfos.add(ctLogInfo);
            }
            this.ctVerifier = new CTVerifier(logId -> logInfos.stream().filter(ctLogInfo -> Arrays.equals(ctLogInfo.getID(), logId)).findFirst().orElse(null));
        } else {
            this.ctVerifier = null;
        }
    }

    public void verifySct(SigningCertificate signingCertificate) throws FulcioVerificationException {
        if (this.ctVerifier == null) {
            throw new FulcioVerificationException("No ct-log public key was provided to verifier");
        }
        if (signingCertificate.getDetachedSct().isPresent()) {
            CertificateEntry ce;
            try {
                ce = CertificateEntry.createForX509Certificate(signingCertificate.getLeafCertificate());
            }
            catch (CertificateEncodingException cee) {
                throw new FulcioVerificationException("Leaf certificate could not be parsed", cee);
            }
            VerifiedSCT.Status status = this.ctVerifier.verifySingleSCT(signingCertificate.getDetachedSct().get(), ce);
            if (status != VerifiedSCT.Status.VALID) {
                throw new FulcioVerificationException("SCT could not be verified because " + status.toString());
            }
        } else if (signingCertificate.hasEmbeddedSct()) {
            CTVerificationResult result;
            List<X509Certificate> certs = signingCertificate.getCertificates();
            try {
                result = this.ctVerifier.verifySignedCertificateTimestamps(certs, null, null);
            }
            catch (CertificateEncodingException cee) {
                throw new FulcioVerificationException("Certificates could not be parsed during sct verification");
            }
            int valid = result.getValidSCTs().size();
            int invalid = result.getInvalidSCTs().size();
            if (valid == 0 || invalid != 0) {
                throw new FulcioVerificationException("Expecting at least one valid sct, but found " + valid + " valid and " + invalid + " invalid scts");
            }
        } else {
            throw new FulcioVerificationException("No detached or embedded SCTs were found to verify");
        }
    }

    public void verifyCertChain(SigningCertificate signingCertificate) throws FulcioVerificationException {
        PKIXParameters pkixParams;
        CertPathValidator cpv;
        try {
            cpv = CertPathValidator.getInstance("PKIX");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("No PKIX CertPathValidator, we probably shouldn't be here, but this seems to be a system library error not a program control flow issue", e);
        }
        try {
            pkixParams = new PKIXParameters(Collections.singleton(this.fulcioRoot));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("Can't create PKIX parameters for fulcioRoot. This should have been checked when generating a verifier instance", e);
        }
        pkixParams.setRevocationEnabled(false);
        Date dateInValidityPeriod = new Date(signingCertificate.getLeafCertificate().getNotBefore().getTime());
        pkixParams.setDate(dateInValidityPeriod);
        try {
            cpv.validate(signingCertificate.getCertPath(), pkixParams);
        }
        catch (InvalidAlgorithmParameterException | CertPathValidatorException ve) {
            throw new FulcioVerificationException(ve);
        }
    }
}

