/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.fulcio.client;

import com.google.protobuf.ByteString;
import dev.sigstore.encryption.certificates.transparency.SerializationException;
import dev.sigstore.fulcio.client.CertificateRequest;
import dev.sigstore.fulcio.client.SigningCertificate;
import dev.sigstore.fulcio.v2.CAGrpc;
import dev.sigstore.fulcio.v2.CreateSigningCertificateRequest;
import dev.sigstore.fulcio.v2.Credentials;
import dev.sigstore.fulcio.v2.PublicKey;
import dev.sigstore.fulcio.v2.PublicKeyRequest;
import dev.sigstore.fulcio.v2.SigningCertificate;
import dev.sigstore.http.GrpcChannels;
import dev.sigstore.http.HttpParams;
import dev.sigstore.http.ImmutableHttpParams;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.IOException;
import java.net.URI;
import java.security.cert.CertificateException;
import java.util.Base64;
import java.util.concurrent.TimeUnit;

public class FulcioClient {
    public static final String PUBLIC_FULCIO_SERVER = "fulcio.sigstore.dev";
    public static final String STAGING_FULCIO_SERVER = "fulcio.sigstage.dev";
    public static final boolean DEFAULT_REQUIRE_SCT = true;
    private final HttpParams httpParams;
    private final URI serverUrl;
    private final boolean requireSct;

    public static Builder builder() {
        return new Builder();
    }

    private FulcioClient(HttpParams httpParams, URI serverUrl, boolean requireSct) {
        this.serverUrl = serverUrl;
        this.requireSct = requireSct;
        this.httpParams = httpParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SigningCertificate signingCertificate(CertificateRequest request) throws InterruptedException, CertificateException, IOException {
        ManagedChannel channel = GrpcChannels.newManagedChannel(this.serverUrl, this.httpParams);
        try {
            CAGrpc.CABlockingStub client = CAGrpc.newBlockingStub((Channel)channel);
            Credentials credentials = Credentials.newBuilder().setOidcIdentityToken(request.getIdToken()).build();
            String pemEncodedPublicKey = "-----BEGIN PUBLIC KEY-----\n" + Base64.getEncoder().encodeToString(request.getPublicKey().getEncoded()) + "\n-----END PUBLIC KEY-----";
            PublicKeyRequest publicKeyRequest = PublicKeyRequest.newBuilder().setPublicKey(PublicKey.newBuilder().setAlgorithm(request.getPublicKeyAlgorithm()).setContent(pemEncodedPublicKey).build()).setProofOfPossession(ByteString.copyFrom((byte[])request.getProofOfPossession())).build();
            CreateSigningCertificateRequest req = CreateSigningCertificateRequest.newBuilder().setCredentials(credentials).setPublicKeyRequest(publicKeyRequest).build();
            dev.sigstore.fulcio.v2.SigningCertificate certs = ((CAGrpc.CABlockingStub)client.withDeadlineAfter(this.httpParams.getTimeout(), TimeUnit.SECONDS)).createSigningCertificate(req);
            if (certs.getCertificateCase() == SigningCertificate.CertificateCase.SIGNED_CERTIFICATE_DETACHED_SCT) {
                if (certs.getSignedCertificateDetachedSct().getSignedCertificateTimestamp().isEmpty() && this.requireSct) {
                    throw new CertificateException("no signed certificate timestamps were found in response from Fulcio");
                }
                try {
                    SigningCertificate signingCertificate = SigningCertificate.newSigningCertificate(certs.getSignedCertificateDetachedSct());
                    return signingCertificate;
                }
                catch (SerializationException se) {
                    throw new CertificateException("Could not parse detached SCT");
                }
            }
            SigningCertificate signingCertificate = SigningCertificate.newSigningCertificate(certs.getSignedCertificateEmbeddedSct());
            return signingCertificate;
        }
        finally {
            channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
        }
    }

    public static class Builder {
        private URI serverUrl = URI.create("fulcio.sigstore.dev");
        private boolean requireSct = true;
        private HttpParams httpParams = ImmutableHttpParams.builder().build();

        private Builder() {
        }

        public Builder setHttpParams(HttpParams httpParams) {
            this.httpParams = httpParams;
            return this;
        }

        public Builder setServerUrl(URI uri) {
            this.serverUrl = uri;
            return this;
        }

        public Builder requireSct(boolean requireSct) {
            this.requireSct = requireSct;
            return this;
        }

        public FulcioClient build() {
            return new FulcioClient(this.httpParams, this.serverUrl, this.requireSct);
        }
    }
}

