/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.encryption.certificates.transparency;

import dev.sigstore.encryption.certificates.transparency.Serialization;
import dev.sigstore.encryption.certificates.transparency.SerializationException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.stream.Stream;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;

public class CertificateEntry {
    private final LogEntryType entryType;
    private final byte[] issuerKeyHash;
    private final byte[] certificate;

    private CertificateEntry(LogEntryType entryType, byte[] certificate, byte[] issuerKeyHash) {
        if (entryType == LogEntryType.PRECERT_ENTRY && issuerKeyHash == null) {
            throw new IllegalArgumentException("issuerKeyHash missing for precert entry.");
        }
        if (entryType == LogEntryType.X509_ENTRY && issuerKeyHash != null) {
            throw new IllegalArgumentException("unexpected issuerKeyHash for X509 entry.");
        }
        if (issuerKeyHash != null && issuerKeyHash.length != 32) {
            throw new IllegalArgumentException("issuerKeyHash must be 32 bytes long");
        }
        this.entryType = entryType;
        this.issuerKeyHash = issuerKeyHash;
        this.certificate = certificate;
    }

    public static CertificateEntry createForPrecertificate(byte[] tbsCertificate, byte[] issuerKeyHash) {
        return new CertificateEntry(LogEntryType.PRECERT_ENTRY, tbsCertificate, issuerKeyHash);
    }

    public static CertificateEntry createForPrecertificate(X509Certificate leaf, X509Certificate issuer) throws CertificateException {
        try {
            if (!leaf.getNonCriticalExtensionOIDs().contains("1.3.6.1.4.1.11129.2.4.2")) {
                throw new CertificateException("Certificate does not contain embedded signed timestamps");
            }
            Certificate bcCert = Certificate.getInstance((Object)leaf.getEncoded());
            Extensions extensions = bcCert.getTBSCertificate().getExtensions();
            Extension[] filteredExtensionsList = (Extension[])((Stream)Arrays.stream(extensions.getExtensionOIDs()).sequential()).filter(oid -> !oid.getId().equals("1.3.6.1.4.1.11129.2.4.2")).filter(oid -> !oid.getId().equals("1.3.6.1.4.1.11129.2.4.3")).map(arg_0 -> ((Extensions)extensions).getExtension(arg_0)).toArray(Extension[]::new);
            Extensions filteredExtensions = new Extensions(filteredExtensionsList);
            TBSCertificate tbs = bcCert.getTBSCertificate();
            V3TBSCertificateGenerator tbsGenerator = new V3TBSCertificateGenerator();
            tbsGenerator.setSerialNumber(tbs.getSerialNumber());
            tbsGenerator.setSignature(tbs.getSignature());
            tbsGenerator.setIssuer(tbs.getIssuer());
            tbsGenerator.setStartDate(tbs.getStartDate());
            tbsGenerator.setEndDate(tbs.getEndDate());
            tbsGenerator.setSubject(tbs.getSubject());
            tbsGenerator.setSubjectPublicKeyInfo(tbs.getSubjectPublicKeyInfo());
            tbsGenerator.setIssuerUniqueID((DERBitString)tbs.getIssuerUniqueId());
            tbsGenerator.setSubjectUniqueID((DERBitString)tbs.getSubjectUniqueId());
            tbsGenerator.setExtensions(filteredExtensions);
            TBSCertificate precertTbs = tbsGenerator.generateTBSCertificate();
            byte[] issuerKey = issuer.getPublicKey().getEncoded();
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(issuerKey);
            byte[] issuerKeyHash = md.digest();
            return CertificateEntry.createForPrecertificate(precertTbs.getEncoded(), issuerKeyHash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (IOException ex) {
            throw new CertificateException("Could not create precertificate", ex);
        }
    }

    public static CertificateEntry createForX509Certificate(byte[] x509Certificate) {
        return new CertificateEntry(LogEntryType.X509_ENTRY, x509Certificate, null);
    }

    public static CertificateEntry createForX509Certificate(X509Certificate cert) throws CertificateEncodingException {
        return CertificateEntry.createForX509Certificate(cert.getEncoded());
    }

    public LogEntryType getEntryType() {
        return this.entryType;
    }

    public byte[] getCertificate() {
        return this.certificate;
    }

    public byte[] getIssuerKeyHash() {
        return this.issuerKeyHash;
    }

    public void encode(OutputStream output) throws SerializationException {
        Serialization.writeNumber(output, this.entryType.ordinal(), 2);
        if (this.entryType == LogEntryType.PRECERT_ENTRY) {
            Serialization.writeFixedBytes(output, this.issuerKeyHash);
        }
        Serialization.writeVariableBytes(output, this.certificate, 3);
    }

    public static enum LogEntryType {
        X509_ENTRY,
        PRECERT_ENTRY;

    }
}

