/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.encryption.certificates;

import com.google.api.client.util.PemReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class Certificates {
    public static String toPemString(Certificate cert) throws IOException {
        StringWriter certWriter = new StringWriter();
        try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)certWriter);){
            pemWriter.writeObject((Object)cert);
            pemWriter.flush();
        }
        return certWriter.toString();
    }

    public static byte[] toPemBytes(Certificate cert) throws IOException {
        return Certificates.toPemString(cert).getBytes(StandardCharsets.UTF_8);
    }

    public static Certificate fromPem(String cert) throws CertificateException {
        List<? extends Certificate> certs = Certificates.fromPemChain(cert).getCertificates();
        if (certs.size() > 1) {
            throw new CertificateException("Found chain of length " + certs.size() + " when parsing a single cert");
        }
        return certs.get(0);
    }

    public static Certificate fromPem(byte[] cert) throws CertificateException {
        return Certificates.fromPem(new String(cert, StandardCharsets.UTF_8));
    }

    public static String toPemString(CertPath certs) throws IOException {
        StringWriter certWriter = new StringWriter();
        try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)certWriter);){
            for (Certificate certificate : certs.getCertificates()) {
                pemWriter.writeObject((Object)certificate);
            }
            pemWriter.flush();
        }
        return certWriter.toString();
    }

    public static byte[] toPemBytes(CertPath certs) throws IOException {
        return Certificates.toPemString(certs).getBytes(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CertPath fromPemChain(String certs) throws CertificateException {
        PemReader pemReader = null;
        try {
            pemReader = new PemReader((Reader)new StringReader(certs));
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            try {
                PemReader.Section section;
                while ((section = pemReader.readNextSection()) != null) {
                    byte[] certBytes = section.getBase64DecodedBytes();
                    certList.add((X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBytes)));
                }
            }
            catch (IOException ioe) {
                throw new CertificateParsingException("Error reading PEM section in cert chain", ioe);
            }
            if (certList.isEmpty()) {
                throw new CertificateParsingException("no valid PEM certificates were found");
            }
            CertPath certPath = cf.generateCertPath(certList);
            return certPath;
        }
        finally {
            if (pemReader != null) {
                try {
                    pemReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static CertPath fromPemChain(byte[] certs) throws CertificateException {
        return Certificates.fromPemChain(new String(certs, StandardCharsets.UTF_8));
    }
}

