/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.bundle;

import com.google.protobuf.ByteString;
import com.google.protobuf.util.JsonFormat;
import dev.sigstore.KeylessSigningResult;
import dev.sigstore.proto.bundle.v1.Bundle;
import dev.sigstore.proto.bundle.v1.VerificationMaterial;
import dev.sigstore.proto.common.v1.HashAlgorithm;
import dev.sigstore.proto.common.v1.HashOutput;
import dev.sigstore.proto.common.v1.LogId;
import dev.sigstore.proto.common.v1.MessageSignature;
import dev.sigstore.proto.common.v1.X509Certificate;
import dev.sigstore.proto.common.v1.X509CertificateChain;
import dev.sigstore.proto.rekor.v1.Checkpoint;
import dev.sigstore.proto.rekor.v1.InclusionPromise;
import dev.sigstore.proto.rekor.v1.InclusionProof;
import dev.sigstore.proto.rekor.v1.KindVersion;
import dev.sigstore.proto.rekor.v1.TransparencyLogEntry;
import dev.sigstore.rekor.client.RekorEntry;
import java.security.cert.CertificateEncodingException;
import java.util.Base64;
import java.util.stream.Collectors;

class BundleFactoryInternal {
    static final JsonFormat.Printer JSON_PRINTER = JsonFormat.printer();

    BundleFactoryInternal() {
    }

    static Bundle.Builder createBundleBuilder(KeylessSigningResult signingResult) {
        return Bundle.newBuilder().setMediaType("application/vnd.dev.sigstore.bundle+json;version=0.1").setVerificationMaterial(BundleFactoryInternal.buildVerificationMaterial(signingResult)).setMessageSignature(MessageSignature.newBuilder().setMessageDigest(HashOutput.newBuilder().setAlgorithm(HashAlgorithm.SHA2_256).setDigest(ByteString.copyFrom((byte[])signingResult.getDigest()))).setSignature(ByteString.copyFrom((byte[])signingResult.getSignature())));
    }

    private static VerificationMaterial.Builder buildVerificationMaterial(KeylessSigningResult signingResult) {
        return VerificationMaterial.newBuilder().setX509CertificateChain(X509CertificateChain.newBuilder().addAllCertificates((Iterable)signingResult.getCertPath().getCertificates().stream().map(c -> {
            byte[] encoded;
            try {
                encoded = c.getEncoded();
            }
            catch (CertificateEncodingException e) {
                throw new IllegalArgumentException("Cannot encode certificate " + c, e);
            }
            return X509Certificate.newBuilder().setRawBytes(ByteString.copyFrom((byte[])encoded)).build();
        }).collect(Collectors.toList()))).addTlogEntries(BundleFactoryInternal.buildTlogEntries(signingResult.getEntry()));
    }

    private static TransparencyLogEntry.Builder buildTlogEntries(RekorEntry entry) {
        TransparencyLogEntry.Builder transparencyLogEntry = TransparencyLogEntry.newBuilder().setLogIndex(entry.getLogIndex()).setLogId(LogId.newBuilder().setKeyId(ByteString.fromHex((String)entry.getLogID()))).setKindVersion(KindVersion.newBuilder().setKind(entry.getBodyDecoded().getKind()).setVersion(entry.getBodyDecoded().getApiVersion())).setIntegratedTime(entry.getIntegratedTime()).setInclusionPromise(InclusionPromise.newBuilder().setSignedEntryTimestamp(ByteString.copyFrom((byte[])Base64.getDecoder().decode(entry.getVerification().getSignedEntryTimestamp())))).setCanonicalizedBody(ByteString.copyFrom((byte[])Base64.getDecoder().decode(entry.getBody())));
        BundleFactoryInternal.addInclusionProof(transparencyLogEntry, entry);
        return transparencyLogEntry;
    }

    private static void addInclusionProof(TransparencyLogEntry.Builder transparencyLogEntry, RekorEntry entry) {
        RekorEntry.InclusionProof inclusionProof = entry.getVerification().getInclusionProof().orElse(null);
        if (inclusionProof == null) {
            return;
        }
        transparencyLogEntry.setInclusionProof(InclusionProof.newBuilder().setLogIndex(entry.getLogIndex()).setRootHash(ByteString.fromHex((String)inclusionProof.getRootHash())).setTreeSize(inclusionProof.getTreeSize().longValue()).addAllHashes((Iterable)inclusionProof.getHashes().stream().map(ByteString::fromHex).collect(Collectors.toList())).setCheckpoint(Checkpoint.newBuilder().setEnvelope(inclusionProof.getCheckpoint())));
    }
}

