/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.bundle;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import dev.sigstore.KeylessSigningResult;
import dev.sigstore.bundle.BundleFactoryInternal;
import dev.sigstore.bundle.BundleVerifierInternal;
import dev.sigstore.proto.bundle.v1.Bundle;
import java.util.List;

public class BundleFactory {
    public static String createBundle(KeylessSigningResult signingResult) {
        Bundle bundle = BundleFactoryInternal.createBundleBuilder(signingResult).build();
        try {
            String jsonBundle = BundleFactoryInternal.JSON_PRINTER.print((MessageOrBuilder)bundle);
            List<String> missingFields = BundleVerifierInternal.findMissingFields((MessageOrBuilder)bundle);
            if (!missingFields.isEmpty()) {
                throw new IllegalStateException("Some of the fields were not initialized: " + String.join((CharSequence)", ", missingFields) + "; bundle JSON: " + jsonBundle);
            }
            return jsonBundle;
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Can't serialize signing result to Sigstore Bundle JSON", e);
        }
    }
}

