/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore;

import com.google.api.client.util.Preconditions;
import dev.sigstore.KeylessVerificationException;
import dev.sigstore.VerificationMaterial;
import dev.sigstore.encryption.certificates.Certificates;
import dev.sigstore.encryption.signers.Verifier;
import dev.sigstore.encryption.signers.Verifiers;
import dev.sigstore.fulcio.client.FulcioVerificationException;
import dev.sigstore.fulcio.client.FulcioVerifier;
import dev.sigstore.fulcio.client.SigningCertificate;
import dev.sigstore.rekor.client.HashedRekordRequest;
import dev.sigstore.rekor.client.RekorClient;
import dev.sigstore.rekor.client.RekorEntry;
import dev.sigstore.rekor.client.RekorVerificationException;
import dev.sigstore.rekor.client.RekorVerifier;
import java.io.IOException;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.sql.Date;
import java.time.Instant;
import java.util.Optional;

public class KeylessVerifier {
    private final FulcioVerifier fulcioVerifier;
    private final RekorVerifier rekorVerifier;
    private final RekorClient rekorClient;

    private KeylessVerifier(FulcioVerifier fulcioVerifier, RekorClient rekorClient, RekorVerifier rekorVerifier) {
        this.fulcioVerifier = fulcioVerifier;
        this.rekorClient = rekorClient;
        this.rekorVerifier = rekorVerifier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void verifyOnline(byte[] artifactDigest, byte[] certChain, byte[] signature) throws KeylessVerificationException, IOException {
        SigningCertificate signingCert;
        try {
            signingCert = SigningCertificate.from(Certificates.fromPemChain(certChain));
        }
        catch (CertificateException ex) {
            throw new KeylessVerificationException("Certificate was not valid: " + ex.getMessage(), ex);
        }
        X509Certificate leafCert = signingCert.getLeafCertificate();
        try {
            this.fulcioVerifier.verifyCertChain(signingCert);
        }
        catch (FulcioVerificationException ex) {
            throw new KeylessVerificationException("Fulcio certificate was not valid: " + ex.getMessage(), ex);
        }
        try {
            this.fulcioVerifier.verifySct(signingCert);
        }
        catch (FulcioVerificationException ex) {
            throw new KeylessVerificationException("Fulcio certificate SCT was not valid: " + ex.getMessage(), ex);
        }
        HashedRekordRequest hashedRekordRequest = HashedRekordRequest.newHashedRekordRequest(artifactDigest, Certificates.toPemBytes(leafCert), signature);
        Optional<RekorEntry> rekorEntry = this.rekorClient.getEntry(hashedRekordRequest);
        if (rekorEntry.isEmpty()) {
            throw new KeylessVerificationException("Rekor entry was not found");
        }
        try {
            this.rekorVerifier.verifyEntry(rekorEntry.get());
        }
        catch (RekorVerificationException ex) {
            throw new KeylessVerificationException("Rekor entry signature was not valid");
        }
        try {
            this.rekorVerifier.verifyInclusionProof(rekorEntry.get());
        }
        catch (RekorVerificationException ex) {
            throw new KeylessVerificationException("Rekor entry inclusion proof was not valid");
        }
        java.util.Date entryTime = Date.from(Instant.ofEpochSecond(rekorEntry.get().getIntegratedTime()));
        try {
            leafCert.checkValidity(entryTime);
        }
        catch (CertificateNotYetValidException e) {
            throw new KeylessVerificationException("Signing time was before certificate validity", e);
        }
        catch (CertificateExpiredException e) {
            throw new KeylessVerificationException("Signing time was after certificate expiry", e);
        }
        PublicKey publicKey = leafCert.getPublicKey();
        try {
            Verifier verifier = Verifiers.newVerifier(publicKey);
            if (!verifier.verifyDigest(artifactDigest, signature)) {
                throw new KeylessVerificationException("Artifact signature was not valid");
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        catch (SignatureException ex) {
            throw new KeylessVerificationException("Signature could not be processed: " + ex.getMessage(), ex);
        }
    }

    public static class Builder {
        private FulcioVerifier fulcioVerifier;
        private RekorClient rekorClient;
        private RekorVerifier rekorVerifier;

        public Builder fulcioVerifier(FulcioVerifier fulcioVerifier) {
            this.fulcioVerifier = fulcioVerifier;
            return this;
        }

        public Builder rekorClient(RekorClient rekorClient, RekorVerifier rekorVerifier) {
            this.rekorClient = rekorClient;
            this.rekorVerifier = rekorVerifier;
            return this;
        }

        public KeylessVerifier build() {
            Preconditions.checkNotNull((Object)this.fulcioVerifier);
            Preconditions.checkNotNull((Object)this.rekorVerifier);
            Preconditions.checkNotNull((Object)this.rekorClient);
            return new KeylessVerifier(this.fulcioVerifier, this.rekorClient, this.rekorVerifier);
        }

        public Builder sigstorePublicDefaults() throws IOException, InvalidAlgorithmParameterException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException {
            this.fulcioVerifier(FulcioVerifier.newFulcioVerifier(VerificationMaterial.Production.fulioCert(), VerificationMaterial.Production.ctfePublicKeys()));
            this.rekorClient(RekorClient.builder().build(), RekorVerifier.newRekorVerifier(VerificationMaterial.Production.rekorPublicKey()));
            return this;
        }

        public Builder sigstoreStagingDefaults() throws IOException, InvalidAlgorithmParameterException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException {
            this.fulcioVerifier(FulcioVerifier.newFulcioVerifier(VerificationMaterial.Staging.fulioCert(), VerificationMaterial.Staging.ctfePublicKeys()));
            this.rekorClient(RekorClient.builder().setServerUrl(URI.create("https://rekor.sigstage.dev")).build(), RekorVerifier.newRekorVerifier(VerificationMaterial.Staging.rekorPublicKey()));
            return this;
        }
    }
}

