/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore;

import com.google.api.client.util.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import dev.sigstore.ImmutableKeylessSigningResult;
import dev.sigstore.KeylessSigningResult;
import dev.sigstore.VerificationMaterial;
import dev.sigstore.encryption.certificates.Certificates;
import dev.sigstore.encryption.signers.Signer;
import dev.sigstore.encryption.signers.Signers;
import dev.sigstore.fulcio.client.CertificateRequest;
import dev.sigstore.fulcio.client.FulcioClient;
import dev.sigstore.fulcio.client.FulcioVerificationException;
import dev.sigstore.fulcio.client.FulcioVerifier;
import dev.sigstore.fulcio.client.SigningCertificate;
import dev.sigstore.fulcio.client.UnsupportedAlgorithmException;
import dev.sigstore.oidc.client.OidcClient;
import dev.sigstore.oidc.client.OidcException;
import dev.sigstore.oidc.client.OidcToken;
import dev.sigstore.oidc.client.WebOidcClient;
import dev.sigstore.rekor.client.HashedRekordRequest;
import dev.sigstore.rekor.client.RekorClient;
import dev.sigstore.rekor.client.RekorResponse;
import dev.sigstore.rekor.client.RekorVerificationException;
import dev.sigstore.rekor.client.RekorVerifier;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.checkerframework.checker.nullness.qual.Nullable;

public class KeylessSigner
implements AutoCloseable {
    public static final Duration DEFAULT_MIN_SIGNING_CERTIFICATE_LIFETIME = Duration.ofMinutes(5L);
    private final FulcioClient fulcioClient;
    private final FulcioVerifier fulcioVerifier;
    private final RekorClient rekorClient;
    private final RekorVerifier rekorVerifier;
    private final OidcClient oidcClient;
    private final Signer signer;
    private final Duration minSigningCertificateLifetime;
    @GuardedBy(value="lock")
    private @Nullable SigningCertificate signingCert;
    @GuardedBy(value="lock")
    private byte @Nullable [] signingCertPemBytes;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private KeylessSigner(FulcioClient fulcioClient, FulcioVerifier fulcioVerifier, RekorClient rekorClient, RekorVerifier rekorVerifier, OidcClient oidcClient, Signer signer, Duration minSigningCertificateLifetime) {
        this.fulcioClient = fulcioClient;
        this.fulcioVerifier = fulcioVerifier;
        this.rekorClient = rekorClient;
        this.rekorVerifier = rekorVerifier;
        this.oidcClient = oidcClient;
        this.signer = signer;
        this.minSigningCertificateLifetime = minSigningCertificateLifetime;
    }

    @Override
    public void close() {
        this.lock.writeLock().lock();
        try {
            this.signingCert = null;
            this.signingCertPemBytes = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @CheckReturnValue
    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public List<KeylessSigningResult> sign(List<byte[]> artifactDigests) throws OidcException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, UnsupportedAlgorithmException, CertificateException, IOException, FulcioVerificationException, RekorVerificationException, InterruptedException {
        if (artifactDigests.size() == 0) {
            throw new IllegalArgumentException("Require one or more digests");
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (byte[] artifactDigest : artifactDigests) {
            byte[] signingCertPemBytes;
            SigningCertificate signingCert;
            byte[] signature = this.signer.signDigest(artifactDigest);
            this.renewSigningCertificate();
            this.lock.readLock().lock();
            try {
                signingCert = this.signingCert;
                signingCertPemBytes = this.signingCertPemBytes;
                if (signingCert == null) {
                    throw new IllegalStateException("Signing certificate is null");
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            HashedRekordRequest rekorRequest = HashedRekordRequest.newHashedRekordRequest(artifactDigest, signingCertPemBytes, signature);
            RekorResponse rekorResponse = this.rekorClient.putEntry(rekorRequest);
            this.rekorVerifier.verifyEntry(rekorResponse.getEntry());
            result.add((Object)ImmutableKeylessSigningResult.builder().digest(artifactDigest).certPath(signingCert.getCertPath()).signature(signature).entry(rekorResponse.getEntry()).build());
        }
        return result.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renewSigningCertificate() throws InterruptedException, CertificateException, IOException, UnsupportedAlgorithmException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, FulcioVerificationException, OidcException {
        this.lock.readLock().lock();
        try {
            long lifetimeLeft;
            if (this.signingCert != null && (lifetimeLeft = this.signingCert.getLeafCertificate().getNotAfter().getTime() - System.currentTimeMillis()) > this.minSigningCertificateLifetime.toMillis()) {
                return;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            this.signingCert = null;
            this.signingCertPemBytes = null;
            OidcToken tokenInfo = this.oidcClient.getIDToken();
            SigningCertificate signingCert = this.fulcioClient.signingCertificate(CertificateRequest.newCertificateRequest(this.signer.getPublicKey(), tokenInfo.getIdToken(), this.signer.sign(tokenInfo.getSubjectAlternativeName().getBytes(StandardCharsets.UTF_8))));
            this.fulcioVerifier.verifyCertChain(signingCert);
            this.fulcioVerifier.verifySct(signingCert);
            this.signingCert = signingCert;
            this.signingCertPemBytes = Certificates.toPemBytes(signingCert.getLeafCertificate());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @CheckReturnValue
    public KeylessSigningResult sign(byte[] artifactDigest) throws FulcioVerificationException, RekorVerificationException, UnsupportedAlgorithmException, CertificateException, NoSuchAlgorithmException, SignatureException, IOException, OidcException, InvalidKeyException, InterruptedException {
        return this.sign(List.of(artifactDigest)).get(0);
    }

    @CheckReturnValue
    public Map<Path, KeylessSigningResult> signFiles(List<Path> artifacts) throws FulcioVerificationException, RekorVerificationException, UnsupportedAlgorithmException, CertificateException, NoSuchAlgorithmException, SignatureException, IOException, OidcException, InvalidKeyException, InterruptedException {
        if (artifacts.size() == 0) {
            throw new IllegalArgumentException("Require one or more paths");
        }
        ArrayList<byte[]> digests = new ArrayList<byte[]>(artifacts.size());
        for (Path artifact : artifacts) {
            ByteSource artifactByteSource = Files.asByteSource((File)artifact.toFile());
            digests.add(artifactByteSource.hash(Hashing.sha256()).asBytes());
        }
        List<KeylessSigningResult> signingResult = this.sign(digests);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (int i = 0; i < artifacts.size(); ++i) {
            result.put((Object)artifacts.get(i), (Object)signingResult.get(i));
        }
        return result.build();
    }

    @CheckReturnValue
    public KeylessSigningResult signFile(Path artifact) throws FulcioVerificationException, RekorVerificationException, UnsupportedAlgorithmException, CertificateException, NoSuchAlgorithmException, SignatureException, IOException, OidcException, InvalidKeyException, InterruptedException {
        return this.signFiles(List.of(artifact)).get(artifact);
    }

    public static class Builder {
        private FulcioClient fulcioClient;
        private FulcioVerifier fulcioVerifier;
        private RekorClient rekorClient;
        private RekorVerifier rekorVerifier;
        private OidcClient oidcClient;
        private Signer signer;
        private Duration minSigningCertificateLifetime = DEFAULT_MIN_SIGNING_CERTIFICATE_LIFETIME;

        @CanIgnoreReturnValue
        public Builder fulcioClient(FulcioClient fulcioClient, FulcioVerifier fulcioVerifier) {
            this.fulcioClient = fulcioClient;
            this.fulcioVerifier = fulcioVerifier;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rekorClient(RekorClient rekorClient, RekorVerifier rekorVerifier) {
            this.rekorClient = rekorClient;
            this.rekorVerifier = rekorVerifier;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder oidcClient(OidcClient oidcClient) {
            this.oidcClient = oidcClient;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder signer(Signer signer) {
            this.signer = signer;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder minSigningCertificateLifetime(Duration minSigningCertificateLifetime) {
            this.minSigningCertificateLifetime = minSigningCertificateLifetime;
            return this;
        }

        @CheckReturnValue
        public KeylessSigner build() {
            Preconditions.checkNotNull((Object)this.fulcioClient, (Object)"fulcioClient");
            Preconditions.checkNotNull((Object)this.fulcioVerifier, (Object)"fulcioVerifier");
            Preconditions.checkNotNull((Object)this.rekorClient, (Object)"rekorClient");
            Preconditions.checkNotNull((Object)this.rekorVerifier, (Object)"rekorVerifier");
            Preconditions.checkNotNull((Object)this.oidcClient, (Object)"oidcClient");
            Preconditions.checkNotNull((Object)this.signer, (Object)"signer");
            return new KeylessSigner(this.fulcioClient, this.fulcioVerifier, this.rekorClient, this.rekorVerifier, this.oidcClient, this.signer, this.minSigningCertificateLifetime);
        }

        @CanIgnoreReturnValue
        public Builder sigstorePublicDefaults() throws IOException, InvalidAlgorithmParameterException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException {
            this.fulcioClient(FulcioClient.builder().build(), FulcioVerifier.newFulcioVerifier(VerificationMaterial.Production.fulioCert(), VerificationMaterial.Production.ctfePublicKeys()));
            this.rekorClient(RekorClient.builder().build(), RekorVerifier.newRekorVerifier(VerificationMaterial.Production.rekorPublicKey()));
            this.oidcClient(WebOidcClient.builder().build());
            this.signer(Signers.newEcdsaSigner());
            this.minSigningCertificateLifetime(DEFAULT_MIN_SIGNING_CERTIFICATE_LIFETIME);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder sigstoreStagingDefaults() throws IOException, InvalidAlgorithmParameterException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException {
            this.fulcioClient(FulcioClient.builder().setServerUrl(URI.create("fulcio.sigstage.dev")).build(), FulcioVerifier.newFulcioVerifier(VerificationMaterial.Staging.fulioCert(), VerificationMaterial.Staging.ctfePublicKeys()));
            this.rekorClient(RekorClient.builder().setServerUrl(URI.create("https://rekor.sigstage.dev")).build(), RekorVerifier.newRekorVerifier(VerificationMaterial.Staging.rekorPublicKey()));
            this.oidcClient(WebOidcClient.builder().setIssuer("https://oauth2.sigstage.dev/auth").build());
            this.signer(Signers.newEcdsaSigner());
            this.minSigningCertificateLifetime(DEFAULT_MIN_SIGNING_CERTIFICATE_LIFETIME);
            return this;
        }
    }
}

