/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.KeylessSigningResult;
import dev.sigstore.rekor.client.RekorEntry;
import java.security.cert.CertPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="KeylessSigningResult", generator="Immutables")
@Immutable
public final class ImmutableKeylessSigningResult
implements KeylessSigningResult {
    private final byte[] digest;
    private final CertPath certPath;
    private final byte[] signature;
    private final RekorEntry entry;

    private ImmutableKeylessSigningResult(byte[] digest, CertPath certPath, byte[] signature, RekorEntry entry) {
        this.digest = digest;
        this.certPath = certPath;
        this.signature = signature;
        this.entry = entry;
    }

    @Override
    public byte[] getDigest() {
        return (byte[])this.digest.clone();
    }

    @Override
    public CertPath getCertPath() {
        return this.certPath;
    }

    @Override
    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    @Override
    public RekorEntry getEntry() {
        return this.entry;
    }

    public final ImmutableKeylessSigningResult withDigest(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableKeylessSigningResult(newValue, this.certPath, this.signature, this.entry);
    }

    public final ImmutableKeylessSigningResult withCertPath(CertPath value) {
        if (this.certPath == value) {
            return this;
        }
        CertPath newValue = Objects.requireNonNull(value, "certPath");
        return new ImmutableKeylessSigningResult(this.digest, newValue, this.signature, this.entry);
    }

    public final ImmutableKeylessSigningResult withSignature(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableKeylessSigningResult(this.digest, this.certPath, newValue, this.entry);
    }

    public final ImmutableKeylessSigningResult withEntry(RekorEntry value) {
        if (this.entry == value) {
            return this;
        }
        RekorEntry newValue = Objects.requireNonNull(value, "entry");
        return new ImmutableKeylessSigningResult(this.digest, this.certPath, this.signature, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeylessSigningResult && this.equalTo(0, (ImmutableKeylessSigningResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeylessSigningResult another) {
        return Arrays.equals(this.digest, another.digest) && this.certPath.equals(another.certPath) && Arrays.equals(this.signature, another.signature) && this.entry.equals(another.entry);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.digest);
        h += (h << 5) + this.certPath.hashCode();
        h += (h << 5) + Arrays.hashCode(this.signature);
        h += (h << 5) + this.entry.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"KeylessSigningResult").omitNullValues().add("digest", (Object)Arrays.toString(this.digest)).add("certPath", (Object)this.certPath).add("signature", (Object)Arrays.toString(this.signature)).add("entry", (Object)this.entry).toString();
    }

    public static ImmutableKeylessSigningResult copyOf(KeylessSigningResult instance) {
        if (instance instanceof ImmutableKeylessSigningResult) {
            return (ImmutableKeylessSigningResult)instance;
        }
        return ImmutableKeylessSigningResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="KeylessSigningResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DIGEST = 1L;
        private static final long INIT_BIT_CERT_PATH = 2L;
        private static final long INIT_BIT_SIGNATURE = 4L;
        private static final long INIT_BIT_ENTRY = 8L;
        private long initBits = 15L;
        @Nullable
        private byte[] digest;
        @Nullable
        private CertPath certPath;
        @Nullable
        private byte[] signature;
        @Nullable
        private RekorEntry entry;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(KeylessSigningResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.digest(instance.getDigest());
            this.certPath(instance.getCertPath());
            this.signature(instance.getSignature());
            this.entry(instance.getEntry());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder digest(byte ... digest) {
            this.digest = (byte[])digest.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder certPath(CertPath certPath) {
            this.certPath = Objects.requireNonNull(certPath, "certPath");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signature(byte ... signature) {
            this.signature = (byte[])signature.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder entry(RekorEntry entry) {
            this.entry = Objects.requireNonNull(entry, "entry");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableKeylessSigningResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeylessSigningResult(this.digest, this.certPath, this.signature, this.entry);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("digest");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("certPath");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("signature");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("entry");
            }
            return "Cannot build KeylessSigningResult, some of required attributes are not set " + attributes;
        }
    }
}

