/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.model;

import com.google.gson.JsonElement;
import dev.sigstore.json.GsonSupplier;
import dev.sigstore.json.canonicalizer.JsonCanonicalizer;
import dev.sigstore.tuf.model.Signature;
import dev.sigstore.tuf.model.TufMeta;
import java.io.IOException;
import java.util.List;
import org.immutables.gson.Gson;
import org.immutables.value.Value;

public interface SignedTufMeta<T extends TufMeta> {
    public List<Signature> getSignatures();

    public T getSignedMeta();

    @Value.Derived
    default public T getSignedMeta(Class<T> type) {
        return (T)((TufMeta)GsonSupplier.GSON.get().fromJson(this.getRawSignedMeta(), type));
    }

    @Gson.Named(value="signed")
    public JsonElement getRawSignedMeta();

    @Value.Lazy
    default public byte[] getCanonicalSignedBytes() throws IOException {
        return new JsonCanonicalizer(GsonSupplier.GSON.get().toJson(this.getRawSignedMeta())).getEncodedUTF8();
    }
}

