/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.Hashing;
import dev.sigstore.encryption.Keys;
import dev.sigstore.encryption.signers.Verifiers;
import dev.sigstore.json.GsonSupplier;
import dev.sigstore.tuf.FileExceedsMaxLengthException;
import dev.sigstore.tuf.FileNotFoundException;
import dev.sigstore.tuf.InvalidHashesException;
import dev.sigstore.tuf.MetaFetchResult;
import dev.sigstore.tuf.MetaFetcher;
import dev.sigstore.tuf.MutableTufStore;
import dev.sigstore.tuf.RoleExpiredException;
import dev.sigstore.tuf.RollbackVersionException;
import dev.sigstore.tuf.RootProvider;
import dev.sigstore.tuf.SignatureVerificationException;
import dev.sigstore.tuf.SnapshotTargetMissingException;
import dev.sigstore.tuf.SnapshotTargetVersionException;
import dev.sigstore.tuf.SnapshotVersionMismatchException;
import dev.sigstore.tuf.TargetMetadataMissingException;
import dev.sigstore.tuf.model.Hashes;
import dev.sigstore.tuf.model.Key;
import dev.sigstore.tuf.model.Role;
import dev.sigstore.tuf.model.Root;
import dev.sigstore.tuf.model.RootRole;
import dev.sigstore.tuf.model.Signature;
import dev.sigstore.tuf.model.SignedTufMeta;
import dev.sigstore.tuf.model.Snapshot;
import dev.sigstore.tuf.model.SnapshotMeta;
import dev.sigstore.tuf.model.TargetMeta;
import dev.sigstore.tuf.model.Targets;
import dev.sigstore.tuf.model.Timestamp;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;

public class Updater {
    private static final int MAX_UPDATES = 1024;
    private static final Logger log = Logger.getLogger(Updater.class.getName());
    private Clock clock;
    private Verifiers.Supplier verifiers;
    private MetaFetcher fetcher;
    private ZonedDateTime updateStartTime;
    private RootProvider trustedRootPath;
    private MutableTufStore localStore;

    Updater(Clock clock, Verifiers.Supplier verifiers, MetaFetcher fetcher, RootProvider trustedRootPath, MutableTufStore localStore) {
        this.clock = clock;
        this.verifiers = verifiers;
        this.trustedRootPath = trustedRootPath;
        this.localStore = localStore;
        this.fetcher = fetcher;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void update() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        Root root = this.updateRoot();
        Optional<Timestamp> timestampMaybe = this.updateTimestamp(root);
        if (timestampMaybe.isPresent()) {
            Snapshot snapshot = this.updateSnapshot(root, timestampMaybe.get());
            Targets targets = this.updateTargets(root, snapshot);
            this.downloadTargets(targets);
        }
    }

    Root updateRoot() throws IOException, RoleExpiredException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, FileExceedsMaxLengthException, RollbackVersionException, SignatureVerificationException {
        Optional<MetaFetchResult<Root>> newRootMaybe;
        this.updateStartTime = ZonedDateTime.now(this.clock);
        Optional<Root> localRoot = this.localStore.loadTrustedRoot();
        Root trustedRoot = localRoot.isPresent() ? localRoot.get() : (Root)GsonSupplier.GSON.get().fromJson(this.trustedRootPath.get(), Root.class);
        int baseVersion = trustedRoot.getSignedMeta().getVersion();
        RootRole preUpdateSnapshotRole = trustedRoot.getSignedMeta().getRoles().get("snapshot");
        RootRole preUpdateTimestampRole = trustedRoot.getSignedMeta().getRoles().get("timestamp");
        for (int nextVersion = baseVersion + 1; nextVersion < baseVersion + 1024 && !(newRootMaybe = this.fetcher.getRootAtVersion(nextVersion)).isEmpty(); ++nextVersion) {
            Root newRoot = newRootMaybe.get().getMetaResource();
            this.verifyDelegate(trustedRoot, newRoot);
            this.verifyDelegate(newRoot, newRoot);
            if (newRoot.getSignedMeta().getVersion() != nextVersion) {
                throw new RollbackVersionException(nextVersion, newRoot.getSignedMeta().getVersion());
            }
            trustedRoot = newRoot;
            this.localStore.storeTrustedRoot(trustedRoot);
        }
        ZonedDateTime expires = trustedRoot.getSignedMeta().getExpiresAsDate();
        this.throwIfExpired(expires);
        if (this.hasNewKeys(preUpdateSnapshotRole, trustedRoot.getSignedMeta().getRole(Role.Name.SNAPSHOT)) || this.hasNewKeys(preUpdateTimestampRole, trustedRoot.getSignedMeta().getRole(Role.Name.TIMESTAMP))) {
            this.localStore.clearMetaDueToKeyRotation();
        }
        return trustedRoot;
    }

    private void throwIfExpired(ZonedDateTime expires) {
        if (expires.isBefore(this.updateStartTime)) {
            throw new RoleExpiredException(this.fetcher.getSource(), this.updateStartTime, expires);
        }
    }

    private boolean hasNewKeys(RootRole oldRole, RootRole newRole) {
        return !newRole.getKeyids().stream().allMatch(key -> oldRole.getKeyids().contains(key));
    }

    void verifyDelegate(Root trustedRoot, SignedTufMeta delegate) throws SignatureVerificationException, IOException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        this.verifyDelegate(delegate.getSignatures(), trustedRoot.getSignedMeta().getKeys(), trustedRoot.getSignedMeta().getRole(Role.Name.valueOf(delegate.getSignedMeta().getType().toUpperCase(Locale.ROOT))), delegate.getCanonicalSignedBytes());
    }

    @VisibleForTesting
    void verifyDelegate(List<Signature> signatures, Map<String, Key> publicKeys, Role role, byte[] verificationMaterial) throws InvalidKeySpecException, IOException, NoSuchAlgorithmException {
        HashSet<String> goodSigs = new HashSet<String>(role.getKeyids().size() * 4 / 3);
        for (String keyid : role.getKeyids()) {
            Signature signature;
            Key key;
            Optional<Signature> signatureMaybe = signatures.stream().filter(sig -> sig.getKeyId().equals(keyid)).findFirst();
            if (!signatureMaybe.isPresent() || (key = publicKeys.get((signature = signatureMaybe.get()).getKeyId())) == null) continue;
            String publicKeyContents = key.getKeyVal().get("public");
            PublicKey pubKey = publicKeyContents.startsWith("-----BEGIN PUBLIC KEY-----") ? Keys.parsePublicKey(publicKeyContents.getBytes(StandardCharsets.UTF_8)) : Keys.constructTufPublicKey(Hex.decode((String)publicKeyContents), key.getScheme());
            try {
                byte[] signatureBytes = Hex.decode((String)signature.getSignature());
                if (!this.verifiers.newVerifier(pubKey).verify(verificationMaterial, signatureBytes)) continue;
                goodSigs.add(signature.getKeyId());
            }
            catch (SignatureException e) {
                log.log(Level.FINE, () -> String.format(Locale.ROOT, "TUF: ignored unverifiable signature: '%s' for keyid: '%s'", signature.getSignature(), signature.getKeyId()));
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | DecoderException e) {
                log.log(Level.WARNING, e, () -> Updater.lambda$verifyDelegate$3(signature, keyid, (Exception)e));
            }
        }
        if (goodSigs.size() < role.getThreshold()) {
            throw new SignatureVerificationException(role.getThreshold(), goodSigs.size());
        }
    }

    Optional<Timestamp> updateTimestamp(Root root) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, FileNotFoundException, SignatureVerificationException {
        Timestamp timestamp = this.fetcher.getMeta(Role.Name.TIMESTAMP, Timestamp.class).orElseThrow(() -> new FileNotFoundException("timestamp.json", this.fetcher.getSource())).getMetaResource();
        this.verifyDelegate(root, timestamp);
        Optional<Timestamp> localTimestampMaybe = this.localStore.loadTimestamp();
        if (localTimestampMaybe.isPresent()) {
            Timestamp localTimestamp = localTimestampMaybe.get();
            if (localTimestamp.getSignedMeta().getVersion() > timestamp.getSignedMeta().getVersion()) {
                throw new RollbackVersionException(localTimestamp.getSignedMeta().getVersion(), timestamp.getSignedMeta().getVersion());
            }
            if (localTimestamp.getSignedMeta().getVersion() == timestamp.getSignedMeta().getVersion()) {
                return Optional.empty();
            }
        }
        this.throwIfExpired(timestamp.getSignedMeta().getExpiresAsDate());
        this.localStore.storeMeta(timestamp);
        return Optional.of(timestamp);
    }

    Snapshot updateSnapshot(Root root, Timestamp timestamp) throws IOException, FileNotFoundException, InvalidHashesException, SignatureVerificationException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        int timestampSnapshotVersion = timestamp.getSignedMeta().getSnapshotMeta().getVersion();
        Optional<MetaFetchResult<Snapshot>> snapshotResult = this.fetcher.getMeta(Role.Name.SNAPSHOT, timestampSnapshotVersion, Snapshot.class, timestamp.getSignedMeta().getSnapshotMeta().getLengthOrDefault());
        if (snapshotResult.isEmpty()) {
            throw new FileNotFoundException(timestampSnapshotVersion + ".snapshot.json", this.fetcher.getSource());
        }
        MetaFetchResult<Snapshot> snapshot = snapshotResult.get();
        if (timestamp.getSignedMeta().getSnapshotMeta().getHashes().isPresent()) {
            Updater.verifyHashes("snapshot", snapshot.getRawBytes(), timestamp.getSignedMeta().getSnapshotMeta().getHashes().get());
        }
        this.verifyDelegate(root, snapshot.getMetaResource());
        int snapshotVersion = snapshot.getMetaResource().getSignedMeta().getVersion();
        if (snapshotVersion != timestampSnapshotVersion) {
            throw new SnapshotVersionMismatchException(timestampSnapshotVersion, snapshotVersion);
        }
        Optional<Snapshot> trustedSnapshotMaybe = this.localStore.loadSnapshot();
        if (trustedSnapshotMaybe.isPresent()) {
            Snapshot trustedSnapshot = trustedSnapshotMaybe.get();
            for (Map.Entry<String, SnapshotMeta.SnapshotTarget> trustedTargetEntry : trustedSnapshot.getSignedMeta().getMeta().entrySet()) {
                SnapshotMeta.SnapshotTarget newTargetMeta = snapshot.getMetaResource().getSignedMeta().getMeta().get(trustedTargetEntry.getKey());
                if (newTargetMeta == null) {
                    throw new SnapshotTargetMissingException(trustedTargetEntry.getKey());
                }
                if (newTargetMeta.getVersion() >= trustedTargetEntry.getValue().getVersion()) continue;
                throw new SnapshotTargetVersionException(trustedTargetEntry.getKey(), newTargetMeta.getVersion(), trustedTargetEntry.getValue().getVersion());
            }
        }
        this.throwIfExpired(snapshot.getMetaResource().getSignedMeta().getExpiresAsDate());
        this.localStore.storeMeta(snapshot.getMetaResource());
        return snapshot.getMetaResource();
    }

    @VisibleForTesting
    static void verifyHashes(String name, byte[] data, Hashes hashes) throws InvalidHashesException {
        ArrayList<InvalidHashesException.InvalidHash> badHashes = new ArrayList<InvalidHashesException.InvalidHash>(2);
        String expectedSha512 = hashes.getSha512();
        String expectedSha256 = hashes.getSha256();
        if (expectedSha256 == null && expectedSha512 == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "hashes parameter for %s must contain at least one of sha512 or sha256.", name));
        }
        String computedSha512 = Hashing.sha512().hashBytes(data).toString();
        if (expectedSha512 != null && !computedSha512.equals(expectedSha512)) {
            badHashes.add(new InvalidHashesException.InvalidHash("sha512", expectedSha512, computedSha512));
        }
        String computedSha256 = Hashing.sha256().hashBytes(data).toString();
        if (expectedSha256 != null && !computedSha256.equals(expectedSha256)) {
            badHashes.add(new InvalidHashesException.InvalidHash("sha256", expectedSha256, computedSha256));
        }
        if (!badHashes.isEmpty()) {
            throw new InvalidHashesException(name, (InvalidHashesException.InvalidHash[])badHashes.toArray(InvalidHashesException.InvalidHash[]::new));
        }
    }

    Targets updateTargets(Root root, Snapshot snapshot) throws IOException, FileNotFoundException, InvalidHashesException, SignatureVerificationException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, FileExceedsMaxLengthException {
        SnapshotMeta.SnapshotTarget targetMeta = snapshot.getSignedMeta().getTargetMeta("targets.json");
        Optional<MetaFetchResult<Targets>> targetsResultMaybe = this.fetcher.getMeta(Role.Name.TARGETS, targetMeta.getVersion(), Targets.class, targetMeta.getLengthOrDefault());
        if (targetsResultMaybe.isEmpty()) {
            throw new FileNotFoundException(targetMeta.getVersion() + ".targets.json", this.fetcher.getSource());
        }
        MetaFetchResult<Targets> targetsResult = targetsResultMaybe.get();
        if (targetMeta.getHashes().isPresent()) {
            Updater.verifyHashes(targetMeta.getVersion() + ".targets.json", targetsResult.getRawBytes(), targetMeta.getHashes().get());
        }
        this.verifyDelegate(root, targetsResult.getMetaResource());
        int targetsVersion = targetsResult.getMetaResource().getSignedMeta().getVersion();
        int snapshotTargetsVersion = targetMeta.getVersion();
        if (targetsVersion != snapshotTargetsVersion) {
            throw new SnapshotVersionMismatchException(snapshotTargetsVersion, targetsVersion);
        }
        this.throwIfExpired(targetsResult.getMetaResource().getSignedMeta().getExpiresAsDate());
        this.localStore.storeMeta(targetsResult.getMetaResource());
        return targetsResult.getMetaResource();
    }

    void downloadTargets(Targets targets) throws IOException, TargetMetadataMissingException, FileNotFoundException {
        for (Map.Entry<String, TargetMeta.TargetData> entry : targets.getSignedMeta().getTargets().entrySet()) {
            String targetName = entry.getKey();
            if (entry.getValue() == null) {
                throw new TargetMetadataMissingException(targetName);
            }
            TargetMeta.TargetData targetData = entry.getValue();
            String versionedTargetName = targetData.getHashes().getSha512() + "." + targetName;
            byte[] targetBytes = this.fetcher.fetchResource("targets/" + versionedTargetName, targetData.getLength());
            if (targetBytes == null) {
                throw new FileNotFoundException(targetName, this.fetcher.getSource());
            }
            Updater.verifyHashes(entry.getKey(), targetBytes, targetData.getHashes());
            this.localStore.storeTargetFile(targetName, targetBytes);
        }
    }

    @VisibleForTesting
    MutableTufStore getLocalStore() {
        return this.localStore;
    }

    private static /* synthetic */ String lambda$verifyDelegate$3(Signature signature, String keyid, Exception e) {
        return String.format(Locale.ROOT, "TUF: ignored invalid signature: '%s' for keyid: '%s', because '%s'", signature.getSignature(), keyid, e.getMessage());
    }

    public static class Builder {
        private Clock clock = Clock.systemUTC();
        private Verifiers.Supplier verifiers = Verifiers::newVerifier;
        private MetaFetcher fetcher;
        private RootProvider trustedRootPath;
        private MutableTufStore localStore;

        public Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder setVerifiers(Verifiers.Supplier verifiers) {
            this.verifiers = verifiers;
            return this;
        }

        public Builder setLocalStore(MutableTufStore store) {
            this.localStore = store;
            return this;
        }

        public Builder setTrustedRootPath(RootProvider trustedRootPath) {
            this.trustedRootPath = trustedRootPath;
            return this;
        }

        public Builder setFetcher(MetaFetcher fetcher) {
            this.fetcher = fetcher;
            return this;
        }

        public Updater build() {
            return new Updater(this.clock, this.verifiers, this.fetcher, this.trustedRootPath, this.localStore);
        }
    }
}

