/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import dev.sigstore.proto.trustroot.v1.TrustedRoot;
import dev.sigstore.trustroot.SigstoreTrustedRoot;
import dev.sigstore.tuf.FileSystemTufStore;
import dev.sigstore.tuf.HttpMetaFetcher;
import dev.sigstore.tuf.RootProvider;
import dev.sigstore.tuf.Updater;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.time.Duration;
import java.time.Instant;

public class SigstoreTufClient {
    @VisibleForTesting
    static final String TRUST_ROOT_FILENAME = "trusted_root.json";
    public static final String PUBLIC_GOOD_ROOT_RESOURCE = "dev/sigstore/tuf/sigstore-tuf-root/root.json";
    public static final String STAGING_ROOT_RESOURCE = "dev/sigstore/tuf/tuf-root-staging/root.json";
    private final Updater updater;
    private Instant lastUpdate;
    private SigstoreTrustedRoot sigstoreTrustedRoot;
    private final Duration cacheValidity;

    @VisibleForTesting
    SigstoreTufClient(Updater updater, Duration cacheValidity) {
        this.updater = updater;
        this.cacheValidity = cacheValidity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void update() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, CertificateException {
        if (this.lastUpdate == null || Duration.between(this.lastUpdate, Instant.now()).compareTo(this.cacheValidity) > 0) {
            this.forceUpdate();
        }
    }

    public void forceUpdate() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, CertificateException {
        this.updater.update();
        this.lastUpdate = Instant.now();
        TrustedRoot.Builder trustedRootBuilder = TrustedRoot.newBuilder();
        JsonFormat.parser().merge(new String(this.updater.getLocalStore().getTargetFile(TRUST_ROOT_FILENAME), StandardCharsets.UTF_8), (Message.Builder)trustedRootBuilder);
        this.sigstoreTrustedRoot = SigstoreTrustedRoot.from(trustedRootBuilder.build());
    }

    public SigstoreTrustedRoot getSigstoreTrustedRoot() {
        return this.sigstoreTrustedRoot;
    }

    public static class Builder {
        Duration cacheValidity = Duration.ofDays(1L);
        Path tufCacheLocation = Path.of(System.getProperty("user.home"), new String[0]).resolve(".sigstore-java").resolve("root");
        URL remoteMirror;
        RootProvider trustedRoot;

        public Builder usePublicGoodInstance() {
            if (this.remoteMirror != null || this.trustedRoot != null) {
                throw new IllegalStateException("Using public good after configuring remoteMirror and trustedRoot");
            }
            try {
                this.tufMirror(new URL("https://tuf-repo-cdn.sigstore.dev"), RootProvider.fromResource(SigstoreTufClient.PUBLIC_GOOD_ROOT_RESOURCE));
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
            return this;
        }

        public Builder useStagingInstance() {
            if (this.remoteMirror != null || this.trustedRoot != null) {
                throw new IllegalStateException("Using staging after configuring remoteMirror and trustedRoot");
            }
            try {
                this.tufMirror(new URL("https://tuf-repo-cdn.sigstage.dev"), RootProvider.fromResource(SigstoreTufClient.STAGING_ROOT_RESOURCE));
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
            this.tufCacheLocation = Path.of(System.getProperty("user.home"), new String[0]).resolve(".sigstore-java").resolve("staging").resolve("root");
            return this;
        }

        public Builder tufMirror(URL mirror, RootProvider trustedRoot) {
            this.remoteMirror = mirror;
            this.trustedRoot = trustedRoot;
            return this;
        }

        public Builder cacheValidity(Duration duration) {
            this.cacheValidity = duration;
            return this;
        }

        public Builder tufCacheLocation(Path location) {
            this.tufCacheLocation = location;
            return this;
        }

        public SigstoreTufClient build() throws IOException {
            Preconditions.checkState((!this.cacheValidity.isNegative() ? 1 : 0) != 0, (Object)"cacheValidity must be non negative");
            Preconditions.checkNotNull((Object)this.remoteMirror);
            Preconditions.checkNotNull((Object)this.trustedRoot);
            if (!Files.isDirectory(this.tufCacheLocation, new LinkOption[0])) {
                Files.createDirectories(this.tufCacheLocation, new FileAttribute[0]);
            }
            Updater tufUpdater = Updater.builder().setTrustedRootPath(this.trustedRoot).setLocalStore(FileSystemTufStore.newFileSystemStore(this.tufCacheLocation)).setFetcher(HttpMetaFetcher.newFetcher(this.remoteMirror)).build();
            return new SigstoreTufClient(tufUpdater, this.cacheValidity);
        }
    }
}

