/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.ObjectParser;
import com.google.common.base.Preconditions;
import dev.sigstore.http.HttpClients;
import dev.sigstore.http.ImmutableHttpParams;
import dev.sigstore.json.GsonSupplier;
import dev.sigstore.tuf.FileExceedsMaxLengthException;
import dev.sigstore.tuf.MetaFetchResult;
import dev.sigstore.tuf.MetaFetcher;
import dev.sigstore.tuf.TufException;
import dev.sigstore.tuf.model.Role;
import dev.sigstore.tuf.model.Root;
import dev.sigstore.tuf.model.SignedTufMeta;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;

public class HttpMetaFetcher
implements MetaFetcher {
    private static final int MAX_META_BYTES = 101376;
    private final URL mirror;

    HttpMetaFetcher(URL mirror) {
        this.mirror = mirror;
    }

    public static HttpMetaFetcher newFetcher(URL mirror) throws MalformedURLException {
        if (mirror.toString().endsWith("/")) {
            return new HttpMetaFetcher(mirror);
        }
        return new HttpMetaFetcher(new URL(mirror.toExternalForm() + "/"));
    }

    @Override
    public String getSource() {
        return this.mirror.toString();
    }

    @Override
    public Optional<MetaFetchResult<Root>> getRootAtVersion(int version) throws IOException, FileExceedsMaxLengthException {
        String versionFileName = version + ".root.json";
        return this.getMeta(versionFileName, Root.class, null);
    }

    @Override
    public <T extends SignedTufMeta> Optional<MetaFetchResult<T>> getMeta(Role.Name role, Class<T> t) throws IOException, FileExceedsMaxLengthException {
        return this.getMeta(HttpMetaFetcher.getFileName(role, null), t, null);
    }

    @Override
    public <T extends SignedTufMeta> Optional<MetaFetchResult<T>> getMeta(Role.Name role, int version, Class<T> t, Integer maxSize) throws IOException, FileExceedsMaxLengthException {
        Preconditions.checkArgument((version > 0 ? 1 : 0) != 0, (String)"version should be positive, got: %s", (int)version);
        return this.getMeta(HttpMetaFetcher.getFileName(role, version), t, maxSize);
    }

    private static String getFileName(Role.Name role, @Nullable Integer version) {
        String normalizeRoleName = role.name().toLowerCase(Locale.ROOT);
        return version == null ? normalizeRoleName + ".json" : String.format(Locale.ROOT, "%d.%s.json", version, normalizeRoleName);
    }

    <T extends SignedTufMeta> Optional<MetaFetchResult<T>> getMeta(String filename, Class<T> t, Integer maxSize) throws IOException, FileExceedsMaxLengthException {
        byte[] roleBytes = this.fetchResource(filename, maxSize == null ? 101376 : maxSize);
        if (roleBytes == null) {
            return Optional.empty();
        }
        MetaFetchResult<SignedTufMeta> result = new MetaFetchResult<SignedTufMeta>(roleBytes, (SignedTufMeta)GsonSupplier.GSON.get().fromJson(new String(roleBytes, StandardCharsets.UTF_8), t));
        return Optional.of(result);
    }

    @Override
    public byte[] fetchResource(String filename, int maxLength) throws IOException, FileExceedsMaxLengthException {
        GenericUrl fileUrl = new GenericUrl(this.mirror + filename);
        HttpRequest req = HttpClients.newHttpTransport(ImmutableHttpParams.builder().build()).createRequestFactory(request -> request.setParser((ObjectParser)GsonFactory.getDefaultInstance().createJsonObjectParser())).buildGetRequest(fileUrl);
        req.getHeaders().setAccept("application/json; api-version=2.0");
        req.getHeaders().setContentType("application/json");
        req.setThrowExceptionOnExecuteError(false);
        HttpResponse resp = req.execute();
        if (resp.getStatusCode() == 404) {
            return null;
        }
        if (resp.getStatusCode() != 200) {
            throw new TufException(String.format(Locale.ROOT, "Unexpected return from mirror(%s). Status code: %s, status message: %s", this.mirror, resp.getStatusCode(), resp.getStatusMessage()));
        }
        byte[] roleBytes = resp.getContent().readNBytes(maxLength);
        if (roleBytes.length == maxLength && resp.getContent().read() != -1) {
            throw new FileExceedsMaxLengthException(fileUrl.toString(), maxLength);
        }
        return roleBytes;
    }
}

