/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf;

import com.google.common.annotations.VisibleForTesting;
import dev.sigstore.json.GsonSupplier;
import dev.sigstore.tuf.MutableTufStore;
import dev.sigstore.tuf.model.Role;
import dev.sigstore.tuf.model.Root;
import dev.sigstore.tuf.model.SignedTufMeta;
import dev.sigstore.tuf.model.Snapshot;
import dev.sigstore.tuf.model.Targets;
import dev.sigstore.tuf.model.Timestamp;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;

public class FileSystemTufStore
implements MutableTufStore {
    private static final String ROOT_FILE_NAME = "root.json";
    private static final String SNAPSHOT_FILE_NAME = "snapshot.json";
    private static final String TIMESTAMP_FILE_NAME = "timestamp.json";
    private Path repoBaseDir;
    private Path targetsCache;

    @VisibleForTesting
    FileSystemTufStore(Path repoBaseDir, Path targetsCache) {
        this.repoBaseDir = repoBaseDir;
        this.targetsCache = targetsCache;
    }

    public static MutableTufStore newFileSystemStore(Path repoBaseDir) throws IOException {
        if (!Files.isDirectory(repoBaseDir, new LinkOption[0])) {
            throw new IllegalArgumentException(repoBaseDir + " must be a file system directory.");
        }
        Path defaultTargetsCache = repoBaseDir.resolve("targets");
        if (!Files.exists(defaultTargetsCache, new LinkOption[0])) {
            Files.createDirectory(defaultTargetsCache, new FileAttribute[0]);
        }
        return FileSystemTufStore.newFileSystemStore(repoBaseDir, defaultTargetsCache);
    }

    static MutableTufStore newFileSystemStore(Path repoBaseDir, Path targetsCache) {
        if (!Files.isDirectory(repoBaseDir, new LinkOption[0])) {
            throw new IllegalArgumentException(repoBaseDir + " must be a file system directory.");
        }
        if (!Files.isDirectory(targetsCache, new LinkOption[0])) {
            throw new IllegalArgumentException(targetsCache + " must be a file system directory.");
        }
        return new FileSystemTufStore(repoBaseDir, targetsCache);
    }

    @Override
    public String getIdentifier() {
        return this.repoBaseDir.toAbsolutePath().toString();
    }

    @Override
    public Optional<Root> loadTrustedRoot() throws IOException {
        return this.loadRole(Role.Name.ROOT, Root.class);
    }

    @Override
    public Optional<Timestamp> loadTimestamp() throws IOException {
        return this.loadRole(Role.Name.TIMESTAMP, Timestamp.class);
    }

    @Override
    public Optional<Snapshot> loadSnapshot() throws IOException {
        return this.loadRole(Role.Name.SNAPSHOT, Snapshot.class);
    }

    @Override
    public Optional<Targets> loadTargets() throws IOException {
        return this.loadRole(Role.Name.TARGETS, Targets.class);
    }

    @Override
    public void storeTargetFile(String targetName, byte[] targetContents) throws IOException {
        Files.write(this.targetsCache.resolve(targetName), targetContents, new OpenOption[0]);
    }

    @Override
    public byte[] getTargetFile(String targetName) throws IOException {
        return Files.readAllBytes(this.targetsCache.resolve(targetName));
    }

    @Override
    public void storeMeta(SignedTufMeta<?> timestamp) throws IOException {
        this.storeRole(timestamp);
    }

    <T extends SignedTufMeta<?>> Optional<T> loadRole(Role.Name roleName, Class<T> tClass) throws IOException {
        Path roleFile = this.repoBaseDir.resolve(roleName + ".json");
        if (!roleFile.toFile().exists()) {
            return Optional.empty();
        }
        return Optional.of((SignedTufMeta)GsonSupplier.GSON.get().fromJson(Files.readString(roleFile), tClass));
    }

    <T extends SignedTufMeta<?>> void storeRole(T role) throws IOException {
        try (BufferedWriter fileWriter = Files.newBufferedWriter(this.repoBaseDir.resolve(role.getSignedMeta().getType() + ".json"), new OpenOption[0]);){
            GsonSupplier.GSON.get().toJson(role, (Appendable)fileWriter);
        }
    }

    @Override
    public void storeTrustedRoot(Root root) throws IOException {
        Optional<Root> trustedRoot = this.loadTrustedRoot();
        if (trustedRoot.isPresent()) {
            try {
                Files.move(this.repoBaseDir.resolve(ROOT_FILE_NAME), this.repoBaseDir.resolve(trustedRoot.get().getSignedMeta().getVersion() + ".root.json"), new CopyOption[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
        this.storeRole(root);
    }

    @Override
    public void clearMetaDueToKeyRotation() throws IOException {
        File timestampMetaFile;
        File snapshotMetaFile = this.repoBaseDir.resolve(SNAPSHOT_FILE_NAME).toFile();
        if (snapshotMetaFile.exists()) {
            Files.delete(snapshotMetaFile.toPath());
        }
        if ((timestampMetaFile = this.repoBaseDir.resolve(TIMESTAMP_FILE_NAME).toFile()).exists()) {
            Files.delete(timestampMetaFile.toPath());
        }
    }
}

