/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.trustroot;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.trustroot.PublicKey;
import dev.sigstore.trustroot.ValidFor;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PublicKey", generator="Immutables")
@Immutable
public final class ImmutablePublicKey
extends PublicKey {
    private final byte[] rawBytes;
    private final String keyDetails;
    private final ValidFor validFor;
    private volatile transient long lazyInitBitmap;
    private static final long TO_JAVA_PUBLIC_KEY_LAZY_INIT_BIT = 1L;
    private transient java.security.PublicKey toJavaPublicKey;

    private ImmutablePublicKey(byte[] rawBytes, String keyDetails, ValidFor validFor) {
        this.rawBytes = rawBytes;
        this.keyDetails = keyDetails;
        this.validFor = validFor;
    }

    @Override
    public byte[] getRawBytes() {
        return (byte[])this.rawBytes.clone();
    }

    @Override
    public String getKeyDetails() {
        return this.keyDetails;
    }

    @Override
    public ValidFor getValidFor() {
        return this.validFor;
    }

    public final ImmutablePublicKey withRawBytes(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutablePublicKey(newValue, this.keyDetails, this.validFor);
    }

    public final ImmutablePublicKey withKeyDetails(String value) {
        String newValue = Objects.requireNonNull(value, "keyDetails");
        if (this.keyDetails.equals(newValue)) {
            return this;
        }
        return new ImmutablePublicKey(this.rawBytes, newValue, this.validFor);
    }

    public final ImmutablePublicKey withValidFor(ValidFor value) {
        if (this.validFor == value) {
            return this;
        }
        ValidFor newValue = Objects.requireNonNull(value, "validFor");
        return new ImmutablePublicKey(this.rawBytes, this.keyDetails, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePublicKey && this.equalTo(0, (ImmutablePublicKey)another);
    }

    private boolean equalTo(int synthetic, ImmutablePublicKey another) {
        return Arrays.equals(this.rawBytes, another.rawBytes) && this.keyDetails.equals(another.keyDetails) && this.validFor.equals(another.validFor);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.rawBytes);
        h += (h << 5) + this.keyDetails.hashCode();
        h += (h << 5) + this.validFor.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PublicKey").omitNullValues().add("rawBytes", (Object)Arrays.toString(this.rawBytes)).add("keyDetails", (Object)this.keyDetails).add("validFor", (Object)this.validFor).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.security.PublicKey toJavaPublicKey() throws InvalidKeySpecException, NoSuchAlgorithmException {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutablePublicKey immutablePublicKey = this;
            synchronized (immutablePublicKey) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.toJavaPublicKey = Objects.requireNonNull(super.toJavaPublicKey(), "toJavaPublicKey");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.toJavaPublicKey;
    }

    public static ImmutablePublicKey copyOf(PublicKey instance) {
        if (instance instanceof ImmutablePublicKey) {
            return (ImmutablePublicKey)instance;
        }
        return ImmutablePublicKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PublicKey", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RAW_BYTES = 1L;
        private static final long INIT_BIT_KEY_DETAILS = 2L;
        private static final long INIT_BIT_VALID_FOR = 4L;
        private long initBits = 7L;
        @Nullable
        private byte[] rawBytes;
        @Nullable
        private String keyDetails;
        @Nullable
        private ValidFor validFor;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PublicKey instance) {
            Objects.requireNonNull(instance, "instance");
            this.rawBytes(instance.getRawBytes());
            this.keyDetails(instance.getKeyDetails());
            this.validFor(instance.getValidFor());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rawBytes(byte ... rawBytes) {
            this.rawBytes = (byte[])rawBytes.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyDetails(String keyDetails) {
            this.keyDetails = Objects.requireNonNull(keyDetails, "keyDetails");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validFor(ValidFor validFor) {
            this.validFor = Objects.requireNonNull(validFor, "validFor");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutablePublicKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePublicKey(this.rawBytes, this.keyDetails, this.validFor);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("rawBytes");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("keyDetails");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("validFor");
            }
            return "Cannot build PublicKey, some of required attributes are not set " + attributes;
        }
    }
}

