/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.rekor.client.RekorEntry;
import dev.sigstore.rekor.client.RekorEntryBody;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RekorEntry", generator="Immutables")
@Immutable
public final class ImmutableRekorEntry
implements RekorEntry {
    private final String body;
    private final transient RekorEntryBody bodyDecoded;
    private final long integratedTime;
    private final transient Instant integratedTimeInstant;
    private final String logID;
    private final long logIndex;
    private final RekorEntry.Verification verification;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRekorEntry(String body, long integratedTime, String logID, long logIndex, RekorEntry.Verification verification) {
        this.body = body;
        this.integratedTime = integratedTime;
        this.logID = logID;
        this.logIndex = logIndex;
        this.verification = verification;
        this.bodyDecoded = this.initShim.getBodyDecoded();
        this.integratedTimeInstant = this.initShim.getIntegratedTimeInstant();
        this.initShim = null;
    }

    private RekorEntryBody getBodyDecodedInitialize() {
        return RekorEntry.super.getBodyDecoded();
    }

    private Instant getIntegratedTimeInstantInitialize() {
        return RekorEntry.super.getIntegratedTimeInstant();
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public RekorEntryBody getBodyDecoded() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getBodyDecoded() : this.bodyDecoded;
    }

    @Override
    public long getIntegratedTime() {
        return this.integratedTime;
    }

    @Override
    public Instant getIntegratedTimeInstant() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getIntegratedTimeInstant() : this.integratedTimeInstant;
    }

    @Override
    public String getLogID() {
        return this.logID;
    }

    @Override
    public long getLogIndex() {
        return this.logIndex;
    }

    @Override
    public RekorEntry.Verification getVerification() {
        return this.verification;
    }

    public final ImmutableRekorEntry withBody(String value) {
        String newValue = Objects.requireNonNull(value, "body");
        if (this.body.equals(newValue)) {
            return this;
        }
        return new ImmutableRekorEntry(newValue, this.integratedTime, this.logID, this.logIndex, this.verification);
    }

    public final ImmutableRekorEntry withIntegratedTime(long value) {
        if (this.integratedTime == value) {
            return this;
        }
        return new ImmutableRekorEntry(this.body, value, this.logID, this.logIndex, this.verification);
    }

    public final ImmutableRekorEntry withLogID(String value) {
        String newValue = Objects.requireNonNull(value, "logID");
        if (this.logID.equals(newValue)) {
            return this;
        }
        return new ImmutableRekorEntry(this.body, this.integratedTime, newValue, this.logIndex, this.verification);
    }

    public final ImmutableRekorEntry withLogIndex(long value) {
        if (this.logIndex == value) {
            return this;
        }
        return new ImmutableRekorEntry(this.body, this.integratedTime, this.logID, value, this.verification);
    }

    public final ImmutableRekorEntry withVerification(RekorEntry.Verification value) {
        if (this.verification == value) {
            return this;
        }
        RekorEntry.Verification newValue = Objects.requireNonNull(value, "verification");
        return new ImmutableRekorEntry(this.body, this.integratedTime, this.logID, this.logIndex, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRekorEntry && this.equalTo(0, (ImmutableRekorEntry)another);
    }

    private boolean equalTo(int synthetic, ImmutableRekorEntry another) {
        return this.body.equals(another.body) && this.bodyDecoded.equals(another.bodyDecoded) && this.integratedTime == another.integratedTime && this.integratedTimeInstant.equals(another.integratedTimeInstant) && this.logID.equals(another.logID) && this.logIndex == another.logIndex && this.verification.equals(another.verification);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.body.hashCode();
        h += (h << 5) + this.bodyDecoded.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.integratedTime);
        h += (h << 5) + this.integratedTimeInstant.hashCode();
        h += (h << 5) + this.logID.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.logIndex);
        h += (h << 5) + this.verification.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RekorEntry").omitNullValues().add("body", (Object)this.body).add("bodyDecoded", (Object)this.bodyDecoded).add("integratedTime", this.integratedTime).add("integratedTimeInstant", (Object)this.integratedTimeInstant).add("logID", (Object)this.logID).add("logIndex", this.logIndex).add("verification", (Object)this.verification).toString();
    }

    public static ImmutableRekorEntry copyOf(RekorEntry instance) {
        if (instance instanceof ImmutableRekorEntry) {
            return (ImmutableRekorEntry)instance;
        }
        return ImmutableRekorEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RekorEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BODY = 1L;
        private static final long INIT_BIT_INTEGRATED_TIME = 2L;
        private static final long INIT_BIT_LOG_I_D = 4L;
        private static final long INIT_BIT_LOG_INDEX = 8L;
        private static final long INIT_BIT_VERIFICATION = 16L;
        private long initBits = 31L;
        @Nullable
        private String body;
        private long integratedTime;
        @Nullable
        private String logID;
        private long logIndex;
        @Nullable
        private RekorEntry.Verification verification;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RekorEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.body(instance.getBody());
            this.integratedTime(instance.getIntegratedTime());
            this.logID(instance.getLogID());
            this.logIndex(instance.getLogIndex());
            this.verification(instance.getVerification());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder body(String body) {
            this.body = Objects.requireNonNull(body, "body");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder integratedTime(long integratedTime) {
            this.integratedTime = integratedTime;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder logID(String logID) {
            this.logID = Objects.requireNonNull(logID, "logID");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder logIndex(long logIndex) {
            this.logIndex = logIndex;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder verification(RekorEntry.Verification verification) {
            this.verification = Objects.requireNonNull(verification, "verification");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableRekorEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRekorEntry(this.body, this.integratedTime, this.logID, this.logIndex, this.verification);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("body");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("integratedTime");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("logID");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("logIndex");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("verification");
            }
            return "Cannot build RekorEntry, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="RekorEntry", generator="Immutables")
    private final class InitShim {
        private byte bodyDecodedBuildStage = 0;
        private RekorEntryBody bodyDecoded;
        private byte integratedTimeInstantBuildStage = 0;
        private Instant integratedTimeInstant;

        private InitShim() {
        }

        RekorEntryBody getBodyDecoded() {
            if (this.bodyDecodedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bodyDecodedBuildStage == 0) {
                this.bodyDecodedBuildStage = (byte)-1;
                this.bodyDecoded = Objects.requireNonNull(ImmutableRekorEntry.this.getBodyDecodedInitialize(), "bodyDecoded");
                this.bodyDecodedBuildStage = 1;
            }
            return this.bodyDecoded;
        }

        Instant getIntegratedTimeInstant() {
            if (this.integratedTimeInstantBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.integratedTimeInstantBuildStage == 0) {
                this.integratedTimeInstantBuildStage = (byte)-1;
                this.integratedTimeInstant = Objects.requireNonNull(ImmutableRekorEntry.this.getIntegratedTimeInstantInitialize(), "integratedTimeInstant");
                this.integratedTimeInstantBuildStage = 1;
            }
            return this.integratedTimeInstant;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.bodyDecodedBuildStage == -1) {
                attributes.add("bodyDecoded");
            }
            if (this.integratedTimeInstantBuildStage == -1) {
                attributes.add("integratedTimeInstant");
            }
            return "Cannot build RekorEntry, attribute initializers form cycle " + attributes;
        }
    }
}

