/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.oidc.client;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.auth.openidconnect.IdTokenVerifier;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.extensions.jetty.auth.oauth2.LocalServerReceiver;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.ObjectParser;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.client.util.store.MemoryDataStoreFactory;
import dev.sigstore.http.HttpClients;
import dev.sigstore.http.HttpParams;
import dev.sigstore.http.ImmutableHttpParams;
import dev.sigstore.oidc.client.ImmutableOidcToken;
import dev.sigstore.oidc.client.OidcClient;
import dev.sigstore.oidc.client.OidcException;
import dev.sigstore.oidc.client.OidcToken;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;

public class WebOidcClient
implements OidcClient {
    private static final Logger log = Logger.getLogger(WebOidcClient.class.getName());
    public static final String PUBLIC_DEX_ISSUER = "https://oauth2.sigstore.dev/auth";
    public static final String STAGING_DEX_ISSUER = "https://oauth2.sigstage.dev/auth";
    private static final String ID_TOKEN_KEY = "id_token";
    private static final String DEFAULT_CLIENT_ID = "sigstore";
    private static final String WELL_KNOWN_CONFIG = "/.well-known/openid-configuration";
    private final HttpParams httpParams;
    private final String clientId;
    private final String issuer;
    private final BrowserHandler browserHandler;

    private WebOidcClient(HttpParams httpParams, String issuer, String clientId, BrowserHandler browserHandler) {
        this.httpParams = httpParams;
        this.clientId = clientId;
        this.issuer = issuer;
        this.browserHandler = browserHandler;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isEnabled(Map<String, String> env) {
        if ("true".equalsIgnoreCase(env.get("CI"))) {
            log.info("Skipping browser based oidc provider because CI detected");
            return false;
        }
        return true;
    }

    @Override
    public OidcToken getIDToken(Map<String, String> env) throws OidcException {
        OIDCEndpoints endpoints;
        GsonFactory jsonFactory = new GsonFactory();
        HttpTransport httpTransport = HttpClients.newHttpTransport(this.httpParams);
        MemoryDataStoreFactory memStoreFactory = new MemoryDataStoreFactory();
        try {
            endpoints = this.parseDiscoveryDocument((JsonFactory)jsonFactory, httpTransport);
        }
        catch (IOException e) {
            throw new OidcException("ioexception obtaining and parsing oidc configuration for " + this.issuer, e);
        }
        AuthorizationCodeFlow.Builder flowBuilder = new AuthorizationCodeFlow.Builder(BearerToken.authorizationHeaderAccessMethod(), httpTransport, (JsonFactory)jsonFactory, new GenericUrl(endpoints.getTokenEndpoint()), (HttpExecuteInterceptor)new ClientParametersAuthentication(this.clientId, null), this.clientId, endpoints.getAuthEndpoint()).enablePKCE().setScopes(Arrays.asList("openid", "email")).setCredentialCreatedListener((arg_0, arg_1) -> WebOidcClient.lambda$getIDToken$0((DataStoreFactory)memStoreFactory, arg_0, arg_1));
        AuthorizationCodeInstalledApp app = new AuthorizationCodeInstalledApp(flowBuilder.build(), (VerificationCodeReceiver)new LocalServerReceiver(), this.browserHandler::openBrowser);
        String idTokenString = null;
        IdToken parsedIdToken = null;
        try {
            app.authorize("user");
            idTokenString = (String)((Object)memStoreFactory.getDataStore("user").get(ID_TOKEN_KEY));
            parsedIdToken = IdToken.parse((JsonFactory)jsonFactory, (String)idTokenString);
            IdTokenVerifier idTokenVerifier = new IdTokenVerifier.Builder().setIssuer(this.issuer).setCertificatesLocation(endpoints.getJwksUri()).build();
            if (!idTokenVerifier.verifyOrThrow(parsedIdToken)) {
                throw new OidcException("id token could not be verified");
            }
        }
        catch (IOException e) {
            throw new OidcException("ioexception during oidc handshake", e);
        }
        String emailFromIDToken = (String)parsedIdToken.getPayload().get((Object)"email");
        boolean emailVerified = (Boolean)parsedIdToken.getPayload().get((Object)"email_verified");
        if (Boolean.FALSE.equals(emailVerified)) {
            throw new OidcException(String.format(Locale.ROOT, "identity provider '%s' reports email address '%s' has not been verified", parsedIdToken.getPayload().getIssuer(), emailFromIDToken));
        }
        return ImmutableOidcToken.builder().subjectAlternativeName(emailFromIDToken).idToken(idTokenString).issuer(this.issuer).build();
    }

    OIDCEndpoints parseDiscoveryDocument(JsonFactory jsonFactory, HttpTransport httpTransport) throws IOException {
        HttpRequestFactory requestFactory = httpTransport.createRequestFactory(request -> request.setParser((ObjectParser)jsonFactory.createJsonObjectParser()));
        GenericUrl wellKnownConfig = new GenericUrl(this.issuer);
        wellKnownConfig.appendRawPath(WELL_KNOWN_CONFIG);
        HttpRequest request2 = requestFactory.buildGetRequest(wellKnownConfig);
        return (OIDCEndpoints)((Object)request2.execute().parseAs(OIDCEndpoints.class));
    }

    private static /* synthetic */ void lambda$getIDToken$0(DataStoreFactory memStoreFactory, Credential credential, TokenResponse tokenResponse) throws IOException {
        memStoreFactory.getDataStore("user").set(ID_TOKEN_KEY, (Serializable)((Object)tokenResponse.get((Object)ID_TOKEN_KEY).toString()));
    }

    @FunctionalInterface
    public static interface BrowserHandler {
        public void openBrowser(String var1) throws IOException;
    }

    public static class OIDCEndpoints
    extends GenericJson {
        @Key(value="authorization_endpoint")
        private String authEndpoint;
        @Key(value="token_endpoint")
        private String tokenEndpoint;
        @Key(value="jwks_uri")
        private String jwksUri;

        public String getAuthEndpoint() {
            return this.authEndpoint;
        }

        public String getTokenEndpoint() {
            return this.tokenEndpoint;
        }

        public String getJwksUri() {
            return this.jwksUri;
        }
    }

    public static class Builder {
        private HttpParams httpParams = ImmutableHttpParams.builder().build();
        private String clientId = "sigstore";
        private String issuer = "https://oauth2.sigstore.dev/auth";
        private BrowserHandler browserHandler = null;

        private Builder() {
        }

        public Builder setHttpParams(HttpParams httpParams) {
            this.httpParams = httpParams;
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setIssuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public Builder setBrowser(BrowserHandler browserHandler) {
            this.browserHandler = browserHandler;
            return this;
        }

        public WebOidcClient build() {
            BrowserHandler bh = this.browserHandler != null ? this.browserHandler : arg_0 -> ((AuthorizationCodeInstalledApp.DefaultBrowser)new AuthorizationCodeInstalledApp.DefaultBrowser()).browse(arg_0);
            return new WebOidcClient(this.httpParams, this.issuer, this.clientId, bh);
        }
    }
}

