/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.oidc.client;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.oidc.client.OidcToken;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OidcToken", generator="Immutables")
@Immutable
public final class ImmutableOidcToken
implements OidcToken {
    private final String subjectAlternativeName;
    private final String issuer;
    private final String idToken;

    private ImmutableOidcToken(String subjectAlternativeName, String issuer, String idToken) {
        this.subjectAlternativeName = subjectAlternativeName;
        this.issuer = issuer;
        this.idToken = idToken;
    }

    @Override
    public String getSubjectAlternativeName() {
        return this.subjectAlternativeName;
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public String getIdToken() {
        return this.idToken;
    }

    public final ImmutableOidcToken withSubjectAlternativeName(String value) {
        String newValue = Objects.requireNonNull(value, "subjectAlternativeName");
        if (this.subjectAlternativeName.equals(newValue)) {
            return this;
        }
        return new ImmutableOidcToken(newValue, this.issuer, this.idToken);
    }

    public final ImmutableOidcToken withIssuer(String value) {
        String newValue = Objects.requireNonNull(value, "issuer");
        if (this.issuer.equals(newValue)) {
            return this;
        }
        return new ImmutableOidcToken(this.subjectAlternativeName, newValue, this.idToken);
    }

    public final ImmutableOidcToken withIdToken(String value) {
        String newValue = Objects.requireNonNull(value, "idToken");
        if (this.idToken.equals(newValue)) {
            return this;
        }
        return new ImmutableOidcToken(this.subjectAlternativeName, this.issuer, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOidcToken && this.equalTo(0, (ImmutableOidcToken)another);
    }

    private boolean equalTo(int synthetic, ImmutableOidcToken another) {
        return this.subjectAlternativeName.equals(another.subjectAlternativeName) && this.issuer.equals(another.issuer) && this.idToken.equals(another.idToken);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.subjectAlternativeName.hashCode();
        h += (h << 5) + this.issuer.hashCode();
        h += (h << 5) + this.idToken.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OidcToken").omitNullValues().add("subjectAlternativeName", (Object)this.subjectAlternativeName).add("issuer", (Object)this.issuer).add("idToken", (Object)this.idToken).toString();
    }

    public static ImmutableOidcToken copyOf(OidcToken instance) {
        if (instance instanceof ImmutableOidcToken) {
            return (ImmutableOidcToken)instance;
        }
        return ImmutableOidcToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OidcToken", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SUBJECT_ALTERNATIVE_NAME = 1L;
        private static final long INIT_BIT_ISSUER = 2L;
        private static final long INIT_BIT_ID_TOKEN = 4L;
        private long initBits = 7L;
        @Nullable
        private String subjectAlternativeName;
        @Nullable
        private String issuer;
        @Nullable
        private String idToken;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OidcToken instance) {
            Objects.requireNonNull(instance, "instance");
            this.subjectAlternativeName(instance.getSubjectAlternativeName());
            this.issuer(instance.getIssuer());
            this.idToken(instance.getIdToken());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder subjectAlternativeName(String subjectAlternativeName) {
            this.subjectAlternativeName = Objects.requireNonNull(subjectAlternativeName, "subjectAlternativeName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder issuer(String issuer) {
            this.issuer = Objects.requireNonNull(issuer, "issuer");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder idToken(String idToken) {
            this.idToken = Objects.requireNonNull(idToken, "idToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableOidcToken build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOidcToken(this.subjectAlternativeName, this.issuer, this.idToken);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("subjectAlternativeName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("issuer");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("idToken");
            }
            return "Cannot build OidcToken, some of required attributes are not set " + attributes;
        }
    }
}

