/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.json.canonicalizer;

import dev.sigstore.json.canonicalizer.JsonDecoder;
import dev.sigstore.json.canonicalizer.NumberToJSON;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class JsonCanonicalizer {
    StringBuilder buffer = new StringBuilder();

    public JsonCanonicalizer(String jsonData) throws IOException {
        this.serialize(new JsonDecoder((String)jsonData).root);
    }

    public JsonCanonicalizer(byte[] jsonData) throws IOException {
        this(new String(jsonData, StandardCharsets.UTF_8));
    }

    private void escape(char c) {
        this.buffer.append('\\').append(c);
    }

    private void serializeString(String value) {
        this.buffer.append('\"');
        block8: for (char c : value.toCharArray()) {
            switch (c) {
                case '\n': {
                    this.buffer.append(c);
                    continue block8;
                }
                case '\b': {
                    this.escape('b');
                    continue block8;
                }
                case '\f': {
                    this.escape('f');
                    continue block8;
                }
                case '\r': {
                    this.escape('r');
                    continue block8;
                }
                case '\t': {
                    this.escape('t');
                    continue block8;
                }
                case '\"': 
                case '\\': {
                    this.escape(c);
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        this.escape('u');
                        for (int i = 0; i < 4; ++i) {
                            int hex = c >>> 12;
                            this.buffer.append((char)(hex > 9 ? hex + 97 - 10 : hex + 48));
                            c = (char)(c << 4);
                        }
                        continue block8;
                    }
                    this.buffer.append(c);
                }
            }
        }
        this.buffer.append('\"');
    }

    void serialize(Object o) throws IOException {
        if (o instanceof TreeMap) {
            this.buffer.append('{');
            boolean next = false;
            for (Map.Entry keyValue : ((TreeMap)o).entrySet()) {
                if (next) {
                    this.buffer.append(',');
                }
                next = true;
                this.serializeString((String)keyValue.getKey());
                this.buffer.append(':');
                this.serialize(keyValue.getValue());
            }
            this.buffer.append('}');
        } else if (o instanceof Vector) {
            this.buffer.append('[');
            boolean next = false;
            for (Object value : ((Vector)o).toArray()) {
                if (next) {
                    this.buffer.append(',');
                }
                next = true;
                this.serialize(value);
            }
            this.buffer.append(']');
        } else if (o == null) {
            this.buffer.append("null");
        } else if (o instanceof String) {
            this.serializeString((String)o);
        } else if (o instanceof Boolean) {
            this.buffer.append((Boolean)o);
        } else if (o instanceof Double) {
            this.buffer.append(NumberToJSON.serializeNumber((Double)o));
        } else {
            throw new InternalError("Unknown object: " + o);
        }
    }

    public String getEncodedString() {
        return this.buffer.toString();
    }

    public byte[] getEncodedUTF8() throws IOException {
        return this.getEncodedString().getBytes(StandardCharsets.UTF_8);
    }
}

