/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.http;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.http.HttpParams;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HttpParams", generator="Immutables")
@Immutable
public final class ImmutableHttpParams
extends HttpParams {
    private final String userAgent;
    private final int timeout;
    private final boolean allowInsecureConnections;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableHttpParams(Builder builder) {
        if (builder.userAgent != null) {
            this.initShim.userAgent(builder.userAgent);
        }
        if (builder.timeoutIsSet()) {
            this.initShim.timeout(builder.timeout);
        }
        if (builder.allowInsecureConnectionsIsSet()) {
            this.initShim.allowInsecureConnections(builder.allowInsecureConnections);
        }
        this.userAgent = this.initShim.getUserAgent();
        this.timeout = this.initShim.getTimeout();
        this.allowInsecureConnections = this.initShim.getAllowInsecureConnections();
        this.initShim = null;
    }

    private ImmutableHttpParams(String userAgent, int timeout, boolean allowInsecureConnections) {
        this.userAgent = userAgent;
        this.timeout = timeout;
        this.allowInsecureConnections = allowInsecureConnections;
        this.initShim = null;
    }

    @Override
    public String getUserAgent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getUserAgent() : this.userAgent;
    }

    @Override
    public int getTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTimeout() : this.timeout;
    }

    @Override
    public boolean getAllowInsecureConnections() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getAllowInsecureConnections() : this.allowInsecureConnections;
    }

    public final ImmutableHttpParams withUserAgent(String value) {
        String newValue = Objects.requireNonNull(value, "userAgent");
        if (this.userAgent.equals(newValue)) {
            return this;
        }
        return ImmutableHttpParams.validate(new ImmutableHttpParams(newValue, this.timeout, this.allowInsecureConnections));
    }

    public final ImmutableHttpParams withTimeout(int value) {
        if (this.timeout == value) {
            return this;
        }
        return ImmutableHttpParams.validate(new ImmutableHttpParams(this.userAgent, value, this.allowInsecureConnections));
    }

    public final ImmutableHttpParams withAllowInsecureConnections(boolean value) {
        if (this.allowInsecureConnections == value) {
            return this;
        }
        return ImmutableHttpParams.validate(new ImmutableHttpParams(this.userAgent, this.timeout, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHttpParams && this.equalTo(0, (ImmutableHttpParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableHttpParams another) {
        return this.userAgent.equals(another.userAgent) && this.timeout == another.timeout && this.allowInsecureConnections == another.allowInsecureConnections;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.userAgent.hashCode();
        h += (h << 5) + this.timeout;
        h += (h << 5) + Booleans.hashCode((boolean)this.allowInsecureConnections);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"HttpParams").omitNullValues().add("userAgent", (Object)this.userAgent).add("timeout", this.timeout).add("allowInsecureConnections", this.allowInsecureConnections).toString();
    }

    private static ImmutableHttpParams validate(ImmutableHttpParams instance) {
        instance.check();
        return instance;
    }

    public static ImmutableHttpParams copyOf(HttpParams instance) {
        if (instance instanceof ImmutableHttpParams) {
            return (ImmutableHttpParams)instance;
        }
        return ImmutableHttpParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HttpParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_TIMEOUT = 1L;
        private static final long OPT_BIT_ALLOW_INSECURE_CONNECTIONS = 2L;
        private long optBits;
        @Nullable
        private String userAgent;
        private int timeout;
        private boolean allowInsecureConnections;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HttpParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.userAgent(instance.getUserAgent());
            this.timeout(instance.getTimeout());
            this.allowInsecureConnections(instance.getAllowInsecureConnections());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder userAgent(String userAgent) {
            this.userAgent = Objects.requireNonNull(userAgent, "userAgent");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timeout(int timeout) {
            this.timeout = timeout;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder allowInsecureConnections(boolean allowInsecureConnections) {
            this.allowInsecureConnections = allowInsecureConnections;
            this.optBits |= 2L;
            return this;
        }

        public ImmutableHttpParams build() {
            return ImmutableHttpParams.validate(new ImmutableHttpParams(this));
        }

        private boolean timeoutIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean allowInsecureConnectionsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Generated(from="HttpParams", generator="Immutables")
    private final class InitShim {
        private byte userAgentBuildStage = 0;
        private String userAgent;
        private byte timeoutBuildStage = 0;
        private int timeout;
        private byte allowInsecureConnectionsBuildStage = 0;
        private boolean allowInsecureConnections;

        private InitShim() {
        }

        String getUserAgent() {
            if (this.userAgentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.userAgentBuildStage == 0) {
                this.userAgentBuildStage = (byte)-1;
                this.userAgent = Objects.requireNonNull(ImmutableHttpParams.super.getUserAgent(), "userAgent");
                this.userAgentBuildStage = 1;
            }
            return this.userAgent;
        }

        void userAgent(String userAgent) {
            this.userAgent = userAgent;
            this.userAgentBuildStage = 1;
        }

        int getTimeout() {
            if (this.timeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.timeoutBuildStage == 0) {
                this.timeoutBuildStage = (byte)-1;
                this.timeout = ImmutableHttpParams.super.getTimeout();
                this.timeoutBuildStage = 1;
            }
            return this.timeout;
        }

        void timeout(int timeout) {
            this.timeout = timeout;
            this.timeoutBuildStage = 1;
        }

        boolean getAllowInsecureConnections() {
            if (this.allowInsecureConnectionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.allowInsecureConnectionsBuildStage == 0) {
                this.allowInsecureConnectionsBuildStage = (byte)-1;
                this.allowInsecureConnections = ImmutableHttpParams.super.getAllowInsecureConnections();
                this.allowInsecureConnectionsBuildStage = 1;
            }
            return this.allowInsecureConnections;
        }

        void allowInsecureConnections(boolean allowInsecureConnections) {
            this.allowInsecureConnections = allowInsecureConnections;
            this.allowInsecureConnectionsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.userAgentBuildStage == -1) {
                attributes.add("userAgent");
            }
            if (this.timeoutBuildStage == -1) {
                attributes.add("timeout");
            }
            if (this.allowInsecureConnectionsBuildStage == -1) {
                attributes.add("allowInsecureConnections");
            }
            return "Cannot build HttpParams, attribute initializers form cycle " + attributes;
        }
    }
}

