/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.http;

import com.google.api.client.util.Preconditions;
import org.immutables.value.Value;

@Value.Immutable
public abstract class HttpParams {
    static final String DEFAULT_USER_AGENT = "sigstoreJavaClient/0.0.1";
    static final int DEFAULT_TIMEOUT = 60;
    static final boolean DEFAULT_ALLOW_INSECURE_CONNECTIONS = false;

    @Value.Default
    public String getUserAgent() {
        return DEFAULT_USER_AGENT;
    }

    @Value.Default
    public int getTimeout() {
        return 60;
    }

    @Value.Default
    public boolean getAllowInsecureConnections() {
        return false;
    }

    @Value.Check
    protected void check() {
        Preconditions.checkState((this.getTimeout() > 0 ? 1 : 0) != 0, (Object)"'timeout' should be greater than zero");
        Preconditions.checkState((!this.getUserAgent().isEmpty() ? 1 : 0) != 0, (Object)"'useragent' must not be empty");
    }
}

