/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.fulcio.client;

import dev.sigstore.VerificationOptions;
import dev.sigstore.fulcio.client.FulcioVerificationException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;

public class FulcioCertificateVerifier {
    private static final String FULCIO_ISSUER_OID = "1.3.6.1.4.1.57264.1.1";
    private static final Logger log = Logger.getLogger(FulcioCertificateVerifier.class.getName());

    public void verifyCertificateMatches(X509Certificate cert, List<VerificationOptions.CertificateIdentity> certIds) throws FulcioVerificationException {
        for (VerificationOptions.CertificateIdentity certId : certIds) {
            if (!this.certificateMatches(cert, certId)) continue;
            return;
        }
        throw new FulcioVerificationException("No provided certificate identities matched values in certificate");
    }

    private boolean certificateMatches(X509Certificate cert, VerificationOptions.CertificateIdentity certId) throws FulcioVerificationException {
        String san = this.extractSan(cert);
        String issuer = this.getExtensionValueRawUtf8(cert, FULCIO_ISSUER_OID);
        if (!Objects.equals(certId.getSubjectAlternativeName(), san)) {
            log.fine("san did not match (" + san + "," + certId.getSubjectAlternativeName() + ")");
            return false;
        }
        if (!Objects.equals(certId.getIssuer(), issuer)) {
            log.fine("issuer did not match (" + issuer + "," + certId.getIssuer() + ")");
            return false;
        }
        for (String otherOid : certId.getOther().keySet()) {
            String entry = this.getExtensionValueRawUtf8(cert, otherOid);
            if (Objects.equals(entry, certId.getOther().get(otherOid))) continue;
            log.fine(otherOid + " did not match (" + entry + "," + certId.getOther().get(otherOid) + ")");
            return false;
        }
        return true;
    }

    private String extractSan(X509Certificate cert) throws FulcioVerificationException {
        try {
            Collection<List<?>> sans = cert.getSubjectAlternativeNames();
            if (sans.size() == 0) {
                throw new FulcioVerificationException("No SANs found in fulcio certificate");
            }
            if (sans.size() > 1) {
                throw new FulcioVerificationException("Fulcio certificate must only have 1 SAN, but found " + sans.size());
            }
            List<?> san = sans.stream().findFirst().get();
            Integer type = (Integer)san.get(0);
            if (!type.equals(1) && !type.equals(6)) {
                throw new FulcioVerificationException("Fulcio certificates SAN must be of type rfc822 or URI");
            }
            return (String)san.get(1);
        }
        catch (CertificateParsingException cpe) {
            throw new FulcioVerificationException("Could not parse SAN from fulcio certificate", cpe);
        }
    }

    private String getExtensionValueRawUtf8(X509Certificate cert, String oid) throws FulcioVerificationException {
        byte[] extensionValue = cert.getExtensionValue(oid);
        if (extensionValue == null) {
            return null;
        }
        try {
            ASN1Primitive derObject = ASN1Sequence.fromByteArray((byte[])cert.getExtensionValue(oid));
            if (derObject instanceof DEROctetString) {
                DEROctetString derOctetString = (DEROctetString)derObject;
                return new String(derOctetString.getOctets(), StandardCharsets.UTF_8);
            }
            throw new FulcioVerificationException("Could not parse extension " + oid + " in certificate because it was not an octet string");
        }
        catch (IOException ioe) {
            throw new FulcioVerificationException("Could not parse extension " + oid + " in certificate", ioe);
        }
    }
}

