/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.encryption.signers;

import dev.sigstore.encryption.signers.EcdsaVerifier;
import dev.sigstore.encryption.signers.RsaVerifier;
import dev.sigstore.encryption.signers.Verifier;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;

public class Verifiers {
    public static Verifier newVerifier(PublicKey publicKey) throws NoSuchAlgorithmException {
        if (publicKey.getAlgorithm().equals("RSA")) {
            return new RsaVerifier(publicKey);
        }
        if (publicKey.getAlgorithm().equals("EC") || publicKey.getAlgorithm().equals("ECDSA")) {
            return new EcdsaVerifier(publicKey);
        }
        throw new NoSuchAlgorithmException("Cannot verify signatures for key type '" + publicKey.getAlgorithm() + "', this client only supports RSA and ECDSA verification");
    }

    @FunctionalInterface
    public static interface Supplier {
        public Verifier newVerifier(PublicKey var1) throws NoSuchAlgorithmException;
    }
}

