/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.encryption.signers;

import dev.sigstore.encryption.signers.EcdsaSigner;
import dev.sigstore.encryption.signers.RsaSigner;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;

public class Signers {
    public static EcdsaSigner newEcdsaSigner() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC");
            keyGen.initialize(256);
            return new EcdsaSigner(keyGen.generateKeyPair());
        }
        catch (NoSuchAlgorithmException nse) {
            throw new RuntimeException("No EC algorithm found in Runtime", nse);
        }
    }

    public static RsaSigner newRsaSigner() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(2048);
            return new RsaSigner(keyGen.generateKeyPair());
        }
        catch (NoSuchAlgorithmException nse) {
            throw new RuntimeException("No RSA algorithm found in Runtime", nse);
        }
    }
}

