/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.encryption.certificates;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.util.encoders.DecoderException;

public class Certificates {
    private static final String SCT_X509_OID = "1.3.6.1.4.1.11129.2.4.2";

    public static String toPemString(Certificate cert) throws IOException {
        StringWriter certWriter = new StringWriter();
        try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)certWriter);){
            pemWriter.writeObject((Object)cert);
            pemWriter.flush();
        }
        return certWriter.toString();
    }

    public static byte[] toPemBytes(Certificate cert) throws IOException {
        return Certificates.toPemString(cert).getBytes(StandardCharsets.UTF_8);
    }

    public static Certificate fromPem(String cert) throws CertificateException {
        List<? extends Certificate> certs = Certificates.fromPemChain(cert).getCertificates();
        if (certs.size() > 1) {
            throw new CertificateException("Found chain of length " + certs.size() + " when parsing a single cert");
        }
        return certs.get(0);
    }

    public static Certificate fromPem(byte[] cert) throws CertificateException {
        return Certificates.fromPem(new String(cert, StandardCharsets.UTF_8));
    }

    public static Certificate fromDer(byte[] cert) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return cf.generateCertificate(new ByteArrayInputStream(cert));
    }

    public static CertPath fromDer(List<byte[]> certChain) throws CertificateException {
        ArrayList<Certificate> certificates = new ArrayList<Certificate>(certChain.size());
        for (byte[] cert : certChain) {
            certificates.add(Certificates.fromDer(cert));
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return cf.generateCertPath(certificates);
    }

    public static String toPemString(CertPath certs) throws IOException {
        StringWriter certWriter = new StringWriter();
        try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)certWriter);){
            for (Certificate certificate : certs.getCertificates()) {
                pemWriter.writeObject((Object)certificate);
            }
            pemWriter.flush();
        }
        return certWriter.toString();
    }

    public static byte[] toPemBytes(CertPath certs) throws IOException {
        return Certificates.toPemString(certs).getBytes(StandardCharsets.UTF_8);
    }

    public static CertPath fromPemChain(String certs) throws CertificateException {
        CertPath certPath;
        PEMParser pemParser = new PEMParser((Reader)new StringReader(certs));
        try {
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            try {
                Object section;
                while ((section = pemParser.readObject()) != null) {
                    if (section instanceof X509CertificateHolder) {
                        X509Certificate certificate = new JcaX509CertificateConverter().getCertificate((X509CertificateHolder)section);
                        certList.add(certificate);
                        continue;
                    }
                    throw new CertificateException("Unsupported pem section: " + section.getClass().toString() + " is not an X509Certificate");
                }
            }
            catch (IOException | DecoderException e) {
                throw new CertificateException("failed to parse PEM object to certificate", e);
            }
            if (certList.isEmpty()) {
                throw new CertificateException("no valid PEM certificates were found");
            }
            certPath = CertificateFactory.getInstance("X.509").generateCertPath(certList);
        }
        catch (Throwable throwable) {
            try {
                try {
                    pemParser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new CertificateException("failed to close PEM parser", e);
            }
        }
        pemParser.close();
        return certPath;
    }

    public static CertPath fromPemChain(byte[] certs) throws CertificateException {
        return Certificates.fromPemChain(new String(certs, StandardCharsets.UTF_8));
    }

    public static CertPath toCertPath(Certificate certificate) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return cf.generateCertPath(Collections.singletonList(certificate));
    }

    public static CertPath append(CertPath parent, CertPath child) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ImmutableList certs = ImmutableList.builder().addAll(child.getCertificates()).addAll(parent.getCertificates()).build();
        return cf.generateCertPath((List<? extends Certificate>)certs);
    }

    public static CertPath trimParent(CertPath certPath, CertPath parentPath) throws CertificateException {
        if (!Certificates.containsParent(certPath, parentPath)) {
            throw new IllegalArgumentException("trim path was not the parent of the provider chain");
        }
        List<? extends Certificate> certs = certPath.getCertificates();
        List<? extends Certificate> parent = parentPath.getCertificates();
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return cf.generateCertPath(certs.subList(0, certs.size() - parent.size()));
    }

    public static boolean containsParent(CertPath certPath, CertPath parentPath) {
        List<? extends Certificate> certs = certPath.getCertificates();
        List<? extends Certificate> parent = parentPath.getCertificates();
        return parent.size() <= certs.size() && certs.subList(certs.size() - parent.size(), certs.size()).equals(parent);
    }

    public static Optional<byte[]> getEmbeddedSCTs(Certificate certificate) {
        return Optional.ofNullable(((X509Certificate)certificate).getExtensionValue(SCT_X509_OID));
    }

    public static boolean isSelfSigned(Certificate certificate) {
        return ((X509Certificate)certificate).getIssuerX500Principal().equals(((X509Certificate)certificate).getSubjectX500Principal());
    }

    public static boolean isSelfSigned(CertPath certPath) {
        return Certificates.isSelfSigned(certPath.getCertificates().get(certPath.getCertificates().size() - 1));
    }

    public static X509Certificate getLeaf(CertPath certPath) {
        return (X509Certificate)certPath.getCertificates().get(0);
    }
}

