/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.encryption;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.ECPointUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.encoders.DecoderException;

public class Keys {
    private static final List<String> SUPPORTED_KEY_TYPES = List.of("ECDSA", "EC", "RSA", "Ed25519", "EdDSA");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PublicKey parsePublicKey(byte[] keyBytes) throws InvalidKeySpecException, IOException, NoSuchAlgorithmException {
        try (PEMParser pemParser = new PEMParser((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(keyBytes), StandardCharsets.UTF_8));){
            Object keyObj = pemParser.readObject();
            if (keyObj == null) {
                throw new InvalidKeySpecException("sigstore public keys must be only a single PEM encoded public key");
            }
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            if (!(keyObj instanceof SubjectPublicKeyInfo)) throw new InvalidKeySpecException("Could not parse PEM section into public key");
            PublicKey pk = converter.getPublicKey((SubjectPublicKeyInfo)keyObj);
            if (!SUPPORTED_KEY_TYPES.contains(pk.getAlgorithm())) {
                throw new NoSuchAlgorithmException("Unsupported key type: " + pk.getAlgorithm());
            }
            PublicKey publicKey = pk;
            return publicKey;
        }
        catch (DecoderException e) {
            throw new InvalidKeySpecException("Invalid key, could not parse PEM section");
        }
    }

    public static PublicKey parsePkixPublicKey(byte[] contents, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(contents);
        KeyFactory factory = KeyFactory.getInstance(algorithm);
        return factory.generatePublic(spec);
    }

    public static PublicKey parsePkcs1RsaPublicKey(byte[] contents) throws NoSuchAlgorithmException, InvalidKeySpecException {
        ASN1Sequence sequence = ASN1Sequence.getInstance((Object)contents);
        ASN1Integer modulus = ASN1Integer.getInstance((Object)sequence.getObjectAt(0));
        ASN1Integer exponent = ASN1Integer.getInstance((Object)sequence.getObjectAt(1));
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(modulus.getPositiveValue(), exponent.getPositiveValue());
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return factory.generatePublic(keySpec);
    }

    public static PublicKey constructTufPublicKey(byte[] contents, String scheme) throws NoSuchAlgorithmException, InvalidKeySpecException {
        switch (scheme) {
            case "ed25519": {
                X509EncodedKeySpec keySpec;
                KeyFactory kf = KeyFactory.getInstance("Ed25519");
                if (contents.length == 32) {
                    SubjectPublicKeyInfo params = new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), contents);
                    try {
                        keySpec = new X509EncodedKeySpec(params.getEncoded());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    keySpec = new X509EncodedKeySpec(contents);
                }
                return kf.generatePublic(keySpec);
            }
            case "ecdsa": 
            case "ecdsa-sha2-nistp256": {
                ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)"P-256");
                KeyFactory kf = null;
                try {
                    kf = KeyFactory.getInstance("ECDSA", "BC");
                }
                catch (NoSuchProviderException e) {
                    throw new RuntimeException(e);
                }
                ECNamedCurveSpec params = new ECNamedCurveSpec("P-256", spec.getCurve(), spec.getG(), spec.getN());
                ECPoint point = ECPointUtil.decodePoint((EllipticCurve)params.getCurve(), (byte[])contents);
                ECPublicKeySpec pubKeySpec = new ECPublicKeySpec(point, (ECParameterSpec)params);
                return kf.generatePublic(pubKeySpec);
            }
        }
        throw new RuntimeException(scheme + " not currently supported");
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

