/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.bundle;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.bundle.Bundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Bundle.MessageDigest", generator="Immutables")
@Immutable
public final class ImmutableMessageDigest
implements Bundle.MessageDigest {
    private final Bundle.HashAlgorithm hashAlgorithm;
    private final byte[] digest;

    private ImmutableMessageDigest(Bundle.HashAlgorithm hashAlgorithm, byte[] digest) {
        this.hashAlgorithm = hashAlgorithm;
        this.digest = digest;
    }

    @Override
    public Bundle.HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Override
    public byte[] getDigest() {
        return (byte[])this.digest.clone();
    }

    public final ImmutableMessageDigest withHashAlgorithm(Bundle.HashAlgorithm value) {
        Bundle.HashAlgorithm newValue = Objects.requireNonNull(value, "hashAlgorithm");
        if (this.hashAlgorithm == newValue) {
            return this;
        }
        return new ImmutableMessageDigest(newValue, this.digest);
    }

    public final ImmutableMessageDigest withDigest(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableMessageDigest(this.hashAlgorithm, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageDigest && this.equalTo(0, (ImmutableMessageDigest)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageDigest another) {
        return this.hashAlgorithm.equals((Object)another.hashAlgorithm) && Arrays.equals(this.digest, another.digest);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.hashAlgorithm.hashCode();
        h += (h << 5) + Arrays.hashCode(this.digest);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MessageDigest").omitNullValues().add("hashAlgorithm", (Object)this.hashAlgorithm).add("digest", (Object)Arrays.toString(this.digest)).toString();
    }

    public static ImmutableMessageDigest copyOf(Bundle.MessageDigest instance) {
        if (instance instanceof ImmutableMessageDigest) {
            return (ImmutableMessageDigest)instance;
        }
        return ImmutableMessageDigest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Bundle.MessageDigest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HASH_ALGORITHM = 1L;
        private static final long INIT_BIT_DIGEST = 2L;
        private long initBits = 3L;
        @Nullable
        private Bundle.HashAlgorithm hashAlgorithm;
        @Nullable
        private byte[] digest;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Bundle.MessageDigest instance) {
            Objects.requireNonNull(instance, "instance");
            this.hashAlgorithm(instance.getHashAlgorithm());
            this.digest(instance.getDigest());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hashAlgorithm(Bundle.HashAlgorithm hashAlgorithm) {
            this.hashAlgorithm = Objects.requireNonNull(hashAlgorithm, "hashAlgorithm");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder digest(byte ... digest) {
            this.digest = (byte[])digest.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMessageDigest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageDigest(this.hashAlgorithm, this.digest);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hashAlgorithm");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("digest");
            }
            return "Cannot build MessageDigest, some of required attributes are not set " + attributes;
        }
    }
}

